select Count(*) TotalFuncExist
  from FuncContrato f,
       FuncLocal fl,
       TipoContrato tp
  where f.CodigoEmpresa = :CodigoEmpresa
    and f.DataAdm < :DataInicial
    and (f.DataDem >= :DataInicial or f.DataDem is null)
    and fl.CodigoEmpresa = f.CodigoEmpresa
    and fl.CodigoFuncContr = f.CodigoFuncContr
    and fl.DataTransf = (select MAX(FuncLocal.DataTransf)
                           from FuncLocal
                          where FuncLocal.CodigoEmpresa = f.CodigoEmpresa
                            and FuncLocal.CodigoFuncContr = f.CodigoFuncContr
                            and FuncLocal.TipoTransf = 1
                            and FuncLocal.DataTransf < :DataInicial)
    and fl.CodigoEstab = :CodigoEstab
    and f.CodigoTipoContr = tp.CodigoTipoContr
    and tp.ConstaCaged = '1'
 order by 1
