SELECT          Tc.Categoria AS Tipocontrato,
                Fl.Codigoempresa,
                Fl.Codigoestab,
                Fc.Codigofunccontr,
                Fp.Certcivilemissao,
                'I' C0902_00,
                (
                       SELECT REPLACE(REPLACE(REPLACE(C.Inscrfederal, '.',''), '/',''), '-','')
                       FROM   Contador C
                       WHERE  C.Codigocont = :pCodigoCont) AS C0419_00,
                Fp.Nomefunc                                   C0195_00,
                CASE
                                WHEN Fp.Datanasc IS NOT NULL THEN Lpad(Extract(Day FROM Fp.Datanasc), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Datanasc), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Datanasc), 4, '0')
                End                                  C0197_00,
                Coalesce(Dpm.Nomedepend, 'Ignorada') C0200_00,
                Coalesce(Dpp.Nomedepend, 'Ignorado') C0199_00,
                CASE
                                WHEN M_nasc.Codigorais IS NOT NULL THEN Substr(M_nasc.Codigorais, 1, 2)
                                                                || Substr(M_nasc.Codigorais, 3, 7)
                End C0390_00,
                CASE
                                WHEN Fp.Sexo = 1 THEN 'M'
                                ELSE 'F'
                End C0201_00,
                CASE Fp.Racacor
                                WHEN 1 THEN '05'
                                WHEN 2 THEN '01'
                                WHEN 4 THEN '02'
                                WHEN 6 THEN '04'
                                WHEN 8 THEN '03'
                                WHEN 9 THEN '01'
                End C0206_00,
                CASE Fp.Grauinstr
                                WHEN 1 THEN '01'
                                WHEN 2 THEN '02'
                                WHEN 3 THEN '03'
                                WHEN 4 THEN '04'
                                WHEN 5 THEN '05'
                                WHEN 6 THEN '06'
                                WHEN 7 THEN '07'
                                WHEN 8 THEN '08'
                                WHEN 9 THEN '09'
                                WHEN 10 THEN '10'
                                WHEN 11 THEN '11'
                                WHEN 12 THEN '12'
                                ELSE '00'
                End C0008_00,
                CASE Fp.Estadocivil
                                WHEN 1 THEN '01'
                                WHEN 2 THEN '02'
                                WHEN 3 THEN '03'
                                WHEN 4 THEN '05'
                                WHEN 5 THEN '06'
                                WHEN 6 THEN '01'
                                WHEN 7 THEN '07'
                                WHEN 8 THEN '08'
                                WHEN 9 THEN '09'
                End C0389_00,
                CASE Fp.Nacionalidade
                                WHEN 10 THEN '0010'
                                WHEN 15 THEN '0010'
                                WHEN 20 THEN '0010'
                                ELSE Lpad(Fp.Nacionalidade, 4, '0')
                End C0386_00,
                CASE Fp.Nacionalidade
                                WHEN 10 THEN '1'
                                WHEN 15 THEN '3'
                                WHEN 20 THEN '2'
                                ELSE '0'
                End C0386_01,
                CASE
                                WHEN Fp.Nacionalidade <> 15 THEN NULL
                                ELSE Ppn.Codigopaisnis
                End                                                            C0387_00,
                REPLACE(REPLACE(REPLACE(Fp.Cpffunc , '.',''), '/',''), '-','') C0370_00,
                Cast (
                CASE
                                WHEN Fp.Titeleit IS NULL THEN NULL
                                WHEN REPLACE(REPLACE(REPLACE(REPLACE(Fp.Titeleit , '.',''), '/',''), '-',''), '0', '') = '' THEN NULL
                                ELSE REPLACE(REPLACE(REPLACE(Fp.Titeleit , '.',''), '/',''), '-','')
                End AS                   Varchar(13)) C0371_00,
                Cast(Fp.Zonatiteleit AS  VARCHAR(4))  C0371_01,
                Cast(Fp.Secaotiteleit AS VARCHAR(4))  C0371_02,
                CASE
                                WHEN Fp.Numerorg IS NULL THEN NULL
                                WHEN REPLACE(REPLACE(REPLACE(REPLACE(Fp.Numerorg, '.',''), '/',''), '-',''), '0', '') = '' THEN NULL
                                ELSE REPLACE(REPLACE(Fp.Numerorg, '.',''), '-','')
                End C0372_00,
                CASE
                                WHEN (
                                                                Fp.Numerorg IS NOT NULL)
                                AND             (
                                                                REPLACE(Fp.Numerorg , ' ','') <> '') THEN Lpad('', 20, ' ')
                End              C0372_01,
                Fp.Siglaestadorg C0372_02,
                CASE
                                WHEN Fp.Emissrg IS NOT NULL THEN Lpad(Extract(Day FROM Fp.Emissrg), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Emissrg), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Emissrg), 4, '0')
                End                                                            C0372_03,
                Fp.Codigoorgaoemissorrg                                        C0372_04,
                Lpad(REPLACE(REPLACE(FTD.Numeroctps, '.',''), '-', ''), 7, '0') C0373_00,
                Lpad(REPLACE(REPLACE(FTD.Seriectps, '.',''), '-', ''), 5, '0')  C0373_01,
                FTD.Siglaestadoctps                                             C0373_02,
                CASE
                                WHEN FTD.Expedctps IS NOT NULL THEN Lpad(Extract(Day FROM FTD.Expedctps), 2, '0')
                                                                || Lpad(Extract(Month FROM FTD.Expedctps), 2, '0')
                                                                || Lpad(Extract(Year FROM FTD.Expedctps), 4, '0')
                End C0373_03,
                CASE Fp.Certciviltipo
                                WHEN '0' THEN 91
                End C0374_00 ,
                CASE Fp.Certciviltipo
                                WHEN '1' THEN 92
                End C0375_00 ,
                CASE Fp.Certciviltipo
                                WHEN '2' THEN 95
                End C0866_00 ,
                CASE Fp.Certciviltipo
                                WHEN '3' THEN 98
                End C0376_00 ,
                CASE Fp.Certciviltipo
                                WHEN '0' THEN Lpad(Extract(Day FROM Fp.Certcivilemissao), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Certcivilemissao), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Certcivilemissao), 4, '0')
                End C0374_01,
                CASE Fp.Certciviltipo
                                WHEN '1' THEN Lpad(Extract(Day FROM Fp.Certcivilemissao), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Certcivilemissao), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Certcivilemissao), 4, '0')
                End C0375_01 ,
                CASE Fp.Certciviltipo
                                WHEN '2' THEN Lpad(Extract(Day FROM Fp.Certcivilemissao), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Certcivilemissao), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Certcivilemissao), 4, '0')
                End C0866_01 ,
                CASE Fp.Certciviltipo
                                WHEN '3' THEN Lpad(Extract(Day FROM Fp.Certcivilemissao), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Certcivilemissao), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Certcivilemissao), 4, '0')
                End C0376_01 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '0')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Lpad(Substr(Fp.Certciviltermo, 1, 8), 8, '0')
                                WHEN (
                                                                Fp.Certciviltipo = '0')
                                AND             (
                                                                Fp.Certcivilemissao >= %3:s) THEN Lpad(Substr(Fp.Certciviltermo, 1, 32), 32, '0')
                End C0374_02 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '1')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Lpad(Substr(Fp.Certciviltermo, 1, 8), 8, '0')
                                WHEN (
                                                                Fp.Certciviltipo = '1')
                                AND             (
                                                                Fp.Certcivilemissao >= %3:s) THEN Lpad(Substr(Fp.Certciviltermo, 1, 32), 32, '0')
                End C0375_02 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '2') THEN Lpad(Substr(Fp.Certciviltermo, 1, 8), 8, '0')
                End C0866_02 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '3')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Lpad(Substr(Fp.Certciviltermo, 1, 8), 8, '0')
                                WHEN (
                                                                Fp.Certciviltipo = '3')
                                AND             (
                                                                Fp.Certcivilemissao >= %3:s) THEN Lpad(Substr(Fp.Certciviltermo, 1, 32), 32, '0')
                End C0376_02 ,
                CASE Fp.Certciviltipo
                                WHEN '0' THEN Mc.Codigorais
                End C0374_03 ,
                CASE Fp.Certciviltipo
                                WHEN '1' THEN Mc.Codigorais
                End C0375_03 ,
                CASE Fp.Certciviltipo
                                WHEN '2' THEN Mc.Codigorais
                End C0866_03 ,
                CASE Fp.Certciviltipo
                                WHEN '3' THEN Mc.Codigorais
                End C0376_03 ,
                CASE Fp.Certciviltipo
                                WHEN '0' THEN Fp.Certcivilsiglaestado
                End C0374_04 ,
                CASE Fp.Certciviltipo
                                WHEN '1' THEN Fp.Certcivilsiglaestado
                End C0375_04 ,
                CASE Fp.Certciviltipo
                                WHEN '2' THEN Fp.Certcivilsiglaestado
                End C0866_04 ,
                CASE Fp.Certciviltipo
                                WHEN '3' THEN Fp.Certcivilsiglaestado
                End C0376_04 ,
                CASE Fp.Certciviltipo
                                WHEN '0' THEN Fp.Certcivilcartorio
                End C0374_05 ,
                CASE Fp.Certciviltipo
                                WHEN '1' THEN Fp.Certcivilcartorio
                End C0375_05 ,
                CASE Fp.Certciviltipo
                                WHEN '2' THEN Fp.Certcivilcartorio
                End C0866_05 ,
                CASE Fp.Certciviltipo
                                WHEN '3' THEN Fp.Certcivilcartorio
                End C0376_05 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '0')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Fp.Certcivillivro
                End C0374_06 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '1')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Fp.Certcivillivro
                End C0375_06 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '2') THEN Fp.Certcivillivro
                End C0866_06 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '3')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Fp.Certcivillivro
                End C0376_06 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '0')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Fp.Certcivilfolha
                End C0374_07 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '1')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Fp.Certcivilfolha
                End C0375_07 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '2') THEN Fp.Certcivilfolha
                End C0866_07 ,
                CASE
                                WHEN (
                                                                Fp.Certciviltipo = '3')
                                AND             (
                                                                Fp.Certcivilemissao < %3:s) THEN Fp.Certcivilfolha
                End                                  C0376_07 ,
                Cast(Fp.Passapnumero AS VARCHAR(15)) C0377_00 ,
                Fp.Passapsiglaestado                 C0377_01,
                CASE
                                WHEN Fp.Passapemissao IS NOT NULL THEN Lpad(Extract(Day FROM Fp.Passapemissao), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Passapemissao), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Passapemissao), 4, '0')
                End                          C0377_02 ,
                Fp.Codigoorgaoemissorpasport C0377_03 ,
                CASE
                                WHEN Fp.Passapvalidade IS NOT NULL THEN Lpad(Extract(Day FROM Fp.Passapvalidade), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Passapvalidade), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Passapvalidade), 4, '0')
                End                                  C0377_04 ,
                Cast(Pp.Codigopaisnis AS VARCHAR(4)) C0377_05,
                CASE
                                WHEN Fp.Datachegada IS NOT NULL THEN Lpad(Extract(Day FROM Fp.Datachegada), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Datachegada), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Datachegada), 4, '0')
                End C0391_00 ,
                CASE
                                WHEN Fp.Nacionalidade = 20 THEN Lpad(Fp.Portnatnumero, 16, 0)
                                ELSE NULL
                End C0401_00,
                CASE
                                WHEN (
                                                                Fp.Datanatural IS NOT NULL)
                                AND             (
                                                                Fp.Nacionalidade = 20) THEN Lpad(Extract(Day FROM Fp.Datanatural), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Datanatural), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Datanatural), 4, '0')
                End                           C0815_00,
                REPLACE(Fp.Ricnumero, '.','') C0416_00,
                Fp.Codigoorgaoemissorric      C0416_01,
                CASE
                                WHEN Mric.Codigorais IS NOT NULL THEN Substr(Mric.Codigorais, 1, 2)
                                                                || '/'
                                                                || Substr(Mric.Codigorais, 3, 7)
                End C0416_02,
                CASE
                                WHEN Fp.Ricdataexped IS NOT NULL THEN Lpad(Extract(Day FROM Fp.Ricdataexped), 2, '0')
                                                                || Lpad(Extract(Month FROM Fp.Ricdataexped), 2, '0')
                                                                || Lpad(Extract(Year FROM Fp.Ricdataexped), 4, '0')
                End                            C0416_03,
                Cast(Fp.Dddfone AS    VARCHAR(3)) C0809_00 ,
                Cast(Fp.Numerofone AS VARCHAR(9)) C0809_01,
                CASE
                                WHEN Fp.Dddfone IS NOT NULL THEN 1
                                ELSE NULL
                End           C0809_02,
                Fp.Endereletr C0810_00,
                REPLACE(REPLACE(
                CASE
                                WHEN :pTipoEndereco = 1 THEN Fp.Cepfunc
                                ELSE E.Cependerestab
                End, '.',''),'-','')            AS C0911_00,
                Cast(:pTipoEndereco AS INTEGER) AS C0911_01,
                CASE
                                WHEN Cast(:pTipoEndereco AS INTEGER) = 1 THEN Tlf.Sigla
                                ELSE
                                                CASE
                                                                WHEN Tle.Sigla IS NULL THEN 'O'
                                                                ELSE Tle.Sigla
                                                End
                End AS C0911_02,
                CASE
                                WHEN Cast(:pTipoEndereco AS INTEGER) = 1 THEN Fp.Enderfunc
                                ELSE E.Enderecoestab
                End   AS C0911_03,
                'Num' AS C0911_04,
                CASE
                                WHEN Cast(:pTipoEndereco AS INTEGER) = 1 THEN Fp.Numeroender
                                ELSE E.Numenderestab
                End AS C0911_05,
                CASE
                                WHEN Cast(:pTipoEndereco AS INTEGER) = 1 THEN Lpad(Fp.Complender, 15, ' ')
                                ELSE Lpad(E.Complenderestab, 15, ' ')
                End AS C0911_06,
                CASE
                                WHEN Cast(:pTipoEndereco AS INTEGER) = 1 THEN Fp.Bairrofunc
                                ELSE E.Bairroenderestab
                End AS C0911_07,
                CASE
                                WHEN Cast(:pTipoEndereco AS INTEGER) = 1 THEN
                                                CASE
                                                                WHEN Mfunc.Codigorais IS NOT NULL THEN Substr(Mfunc.Codigorais, 1, 2)
                                                                                                || Substr(Mfunc.Codigorais, 3, 7)
                                                End
                                ELSE
                                                CASE
                                                                WHEN Mestab.Codigorais IS NOT NULL THEN Substr(Mestab.Codigorais, 1, 2)
                                                                                                || Substr(Mestab.Codigorais, 3, 7)
                                                End
                End AS C0911_08,
                REPLACE(REPLACE(
                CASE
                                WHEN Cast(:pTipoEndereco AS INTEGER) = 3 THEN E.Caixapostal
                End, '.',''),'-','') AS C0938_00,
                REPLACE(REPLACE(
                CASE
                                WHEN Cast(:pTipoEndereco AS INTEGER) = 3 THEN E.Cepcaixapostal
                End, '.',''),'-','') AS C0938_01,
                CASE E.Tipoinscr
                                WHEN 2 THEN 59
                                WHEN 3 THEN 60
                End                                                               C0292_00,
                REPLACE(REPLACE(REPLACE(E.Inscrfederal, '.',''), '/',''), '-','') C0292_01,
                CASE
                                WHEN Fc.Dataadm IS NOT NULL THEN Lpad(Extract(Day FROM Fc.Dataadm), 2, '0')
                                                                || Lpad(Extract(Month FROM Fc.Dataadm), 2, '0')
                                                                || Lpad(Extract(Year FROM Fc.Dataadm), 4, '0')
                End C0292_02
FROM            Funccontrato Fc
JOIN            Funcpessoa Fp
ON              Fp.Codigofuncpessoa = Fc.Codigofuncpessoa
JOIN            Tipocontrato Tc
ON              Tc.Codigotipocontr = Fc.Codigotipocontr
JOIN            Funclocal Fl
ON              Fl.Codigoempresa = Fc.Codigoempresa
AND             Fl.Codigofunccontr = Fc.Codigofunccontr
AND             Fl.Datatransf =
                (
                       SELECT Max(Fls.Datatransf)
                       FROM   Funclocal Fls
                       WHERE  Fls.Codigoempresa = Fl.Codigoempresa
                       AND    Fls.Codigofunccontr = Fl.Codigofunccontr
                       AND    Fls.Datatransf <= %1:s)
JOIN            Municipio M_nasc
ON              Fp.Siglaestadonasc = M_nasc.Siglaestado
AND             Fp.Codigomunicnasc = M_nasc.Codigomunic
JOIN            Estab E
ON              Fl.Codigoempresa = E.Codigoempresa
AND             Fl.Codigoestab = E.Codigoestab
JOIN            Dependente Dpm
ON              Dpm.Codigoempresa = Fc.Codigoempresa
AND             Dpm.Codigofunccontr = Fc.Codigofunccontr
AND             Dpm.Parentesco = '03'
AND             Dpm.Sexo = 2
LEFT JOIN       Dependente Dpp
ON              Dpp.Codigoempresa = Fc.Codigoempresa
AND             Dpp.Codigofunccontr = Fc.Codigofunccontr
AND             Dpp.Parentesco = '03'
AND             Dpp.Sexo = 1
LEFT JOIN       Pais Ppn
ON              Fp.Paisorigem = Ppn.Codigopais
LEFT JOIN (SELECT FTD.CODIGOEMPRESA,
                  FTD.CODIGOFUNCCONTR, 
              MAX(FTD.DATAINICIAL) DATAINICIAL 
            FROM FUNCCTPS FTD 
          GROUP BY FTD.CODIGOEMPRESA, FTD.CODIGOFUNCCONTR) FCTD 
              ON FCTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FCTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
LEFT JOIN FUNCCTPS FTD 
              ON FTD.CODIGOEMPRESA = FC.CODIGOEMPRESA 
             AND FTD.CODIGOFUNCCONTR = FC.CODIGOFUNCCONTR 
             AND FTD.DATAINICIAL = FCTD.DATAINICIAL
LEFT OUTER JOIN Municipio Mfunc
ON              Fp.Siglaestado = Mfunc.Siglaestado
AND             Fp.Codigomunic = Mfunc.Codigomunic
LEFT OUTER JOIN Municipio Mestab
ON              E.Siglaestado = Mestab.Siglaestado
AND             E.Codigomunic = Mestab.Codigomunic
LEFT OUTER JOIN Municipio Mc
ON              Fp.Certcivilsiglaestado = Mc.Siglaestado
AND             Fp.Certcivilmunic = Mc.Codigomunic
LEFT OUTER JOIN Pais Pp
ON              Fp.Passappaisemissao = Pp.Codigopais
LEFT OUTER JOIN Municipio Mric
ON              Fp.Ricsiglaestado = Mric.Siglaestado
AND             Fp.Ricmunic = Mric.Codigomunic
LEFT JOIN       Tipologradouro Tlf
ON              Fp.Codigotipolograd = Tlf.Codigotipolograd
LEFT JOIN       Tipologradouro Tle
ON              E.CODIGOTIPOLOGRAD = Tle.CODIGOTIPOLOGRAD
WHERE           Fc.Dataadm BETWEEN %0:s AND             %1:s %2:s
ORDER BY        Fl.Codigoempresa,
                Fl.Codigoestab,
                Fc.Codigofunccontr