Select I.CodigoEmpresa, 
       E.NomeEmpresa,  
       I.Compet , 
       cast('nFpa' as Varchar(4)) Origem, 
       cast(Sum(I.ReceitaBaseCalcINSS) as numeric(14,2)) ReceitaBaseCalcINSS,
       cast(Sum(I.ReceitaTotal) as numeric(14,2)) ReceitaTotal
  from INSSReceita I
 inner join Empresa E
    on E.CodigoEmpresa = I.codigoEmpresa
 where I.Compet between :pDataInicial and :pDataFinal
  %0:s
 group by I.CodigoEmpresa,
          E.NomeEmpresa,
          I.Compet
union all
 
select E.CodigoEmpresa,
       E.NomeEmpresa,
       I.DataTotal Compet,
       cast('nFis' as Varchar(4)) Origem, 
       cast(I.ValorTotal3 as numeric(14,2)) ReceitaBaseCalcINSS,
       cast((I.ValorTotal3 + I.ValorTotal4) as numeric(14,2)) ReceitaTotal
  from TotalContPatronal I
 inner join Empresa E
    on E.CodigoEmpresa = I.codigoEmpresa   
 where I.DataTotal between :pDataInicial and :pDataFinal
   and I.CodigoOperacaoFis = :pCodigoOperacaoFis
   and not exists(select 1 
                    from INSSReceita IR
                   where IR.CodigoEmpresa = I.CodigoEmpresa
  		             and (cast({extract(MONTH, IR.Compet)} as varchar(2))) = (cast({extract(MONTH, I.DataTotal)} as varchar(2))) 
                     and (cast({extract(YEAR, IR.Compet)} as varchar(4))) = (cast({extract(YEAR, I.DataTotal)} as varchar(4))))
    %0:s
order by 3