select X.CODIGOEMPRESA
        ,1 TIPOINSCRBENEF
        ,FP.CPFFUNC INSCRFEDERALBENEF
     ,FP.NOMEFUNC NOMEBENEF
  ,X.CODIGOIMPOSTO
        ,X.TIPO
      ,extract(month from X.DATAPGTO) mes
     ,X.CAMPOINFORME
     ,sum (X.VALORRENDIMENTO) valorRend
     ,sum (X.VALORIRRF) ValorIRRF
 from INFORMERENDIMENTOOUTREND X
 join FuncContrato F
   on F.CODIGOEMPRESA = X.CODIGOEMPRESA
  and F.CodigoFuncContr = X.CodigoFuncContr
 join FuncPessoa Fp
   on FP.codigoFuncPessoa = F.codigoFuncPessoa
where X.DATAPGTO between :pCompetIni and :pCompetFin 
  %s
  and X.CAMPOINFORME in (1,2,3,4,5,6)
group by X.CODIGOEMPRESA
        ,FP.CPFFUNC
  ,FP.NOMEFUNC
     ,X.CODIGOIMPOSTO
        ,X.TIPO
      ,extract(month from X.DATAPGTO)
     ,X.CAMPOINFORME
union
select X.CODIGOEMPRESA
      ,1 TIPOINSCRBENEF
      ,S.INSCRFEDERAL INSCRFEDERALBENEF
   ,S.NOMESOCIO NOMEBENEF
      ,X.CODIGOIMPOSTO
      ,X.TIPO
    ,extract(month from X.DATAPGTO) mes
      ,X.CAMPOINFORME
      ,sum (X.VALORRENDIMENTO) valorRend
      ,sum (X.VALORIRRF) ValorIRRF
 from INFORMERENDIMENTOOUTREND X
 join SOCIO S
   on S.CODIGOEMPRESA = X.CODIGOEMPRESA
  and S.CODIGOSOCIO = X.CODIGOSOCIO
where X.DATAPGTO between :pCompetIni and :pCompetFin
  %s
  and X.CAMPOINFORME in (1,2,3,4,5,6)
group by X.CODIGOEMPRESA
      ,S.INSCRFEDERAL
   ,S.NOMESOCIO
      ,X.CODIGOIMPOSTO
      ,X.TIPO
    ,extract(month from X.DATAPGTO)
      ,X.CAMPOINFORME
union
select X.CODIGOEMPRESA
      ,1 TIPOINSCRBENEF
      ,T.CPFTERC
   ,T.NOMETERC NOMEBENEF
      ,X.CODIGOIMPOSTO
      ,X.TIPO
    ,extract(month from X.DATAPGTO) mes
      ,X.CAMPOINFORME
      ,sum (X.VALORRENDIMENTO) valorRend
      ,sum (X.VALORIRRF) ValorIRRF
 from INFORMERENDIMENTOOUTREND X
 join TERCEIRO T
   on T.CODIGOTERC = X.CODIGOTERC
where X.DATAPGTO between :pCompetIni and :pCompetFin
  %s
  and X.CAMPOINFORME in (1,2,3,4,5,6)
group by X.CODIGOEMPRESA
      ,T.CPFTERC
   ,T.NOMETERC
      ,X.CODIGOIMPOSTO
      ,X.TIPO
      ,extract(month from X.DATAPGTO)
      ,X.CAMPOINFORME
order by 1, 2, 3, 5
