select oep.TipoArrec,
       cast(sum(oeps.BASEGPS) as numeric(16,2)) Valor
  from CfgEstabFpa cef
  join OutraEmpPgto oep
       on  oep.CodigoEmpresa = cef.CodigoEmpresa
       and oep.CodigoEstab = cef.CodigoEstab
  join OutraEmpPgtoServico oeps
       on  oep.CodigoEmpresa = oeps.CodigoEmpresa
       and oep.codigooutemp = oeps.codigooutemp
       and oep.compet = oeps.compet
       and oep.seq = oeps.seq
 where cef.CodigoEmpresa = :pCodigoEmpresa
   and cef.CodigoEstab = :pCodigoEstab
   and cef.CategFGTS = 2
   and oep.Compet = :pCompet
   and oep.GPSOrigem between 1 and 2
   and oep.CodigoOutEmpGps is null
 group by oep.TipoArrec
union
select 'P' IndicOrigem,
        cast(sum(recs.ValorRcto)  as numeric(16,2)) Valor
  from CfgEstabFpa cef
  join Recebimento rcb
       on  rcb.CodigoEmpresa = cef.CodigoEmpresa
       and rcb.CodigoEstab = cef.CodigoEstab
  join RecebimentoServico recs
       on  rcb.CodigoEmpresa = recs.CodigoEmpresa
       and rcb.CodigoEstab = recs.CodigoEstab
       and rcb.Compet = recs.Compet
       and rcb.seq = recs.seq
 where cef.CodigoEmpresa = :pCodigoEmpresa
   and cef.CodigoEstab = :pCodigoEstab
   and cef.CategFGTS <> 2
   and rcb.Compet = :pCompet
   and rcb.GPSOrigem = 5
   and rcb.CodigoOutEmp is null
union
select oep.TipoArrec,
        cast(sum(oeps.BASEGPS)  as numeric(16,2)) Valor
  from CfgEstabFpa cef
  join OutraEmpPgto oep
       on  oep.CodigoEmpresa = cef.CodigoEmpresa
       and oep.CodigoEstab = cef.CodigoEstab
  join OutraEmpPgtoServico oeps
       on  oep.CodigoEmpresa = oeps.CodigoEmpresa
       and oep.codigooutemp = oeps.codigooutemp
       and oep.compet = oeps.compet
       and oep.seq = oeps.seq
 where cef.CodigoEmpresa = :pCodigoEmpresa
   and cef.CodigoEstab = :pCodigoEstab
   and oep.Compet = :pCompet
   and oep.GPSOrigem = 5
   and oep.CodigoOutEmpGps is null
 group by oep.TipoArrec
order by 1