  select PC.CodigoTipoCalc,
         1 as CadastroRetroativo,
         PC.Compet,
         PC.DataFinalFolha as DataFolha,
         PC.DataFinalVT    as DataVT,
         PC.CodigoPerCalculo
    from PeriodoCalculo PC
   where PC.CodigoEmpresa    = :CodigoEmpresa
     and PC.CodigoPerCalculo <> :CodigoPerCalculo
     and PC.Compet           = (select max(PeC.Compet)
                                  from PeriodoCalculo PeC
                                 where PeC.CodigoEmpresa  = PC.CodigoEmpresa
                                   and PeC.CodigoTipoCalc = PC.CodigoTipoCalc)
     and PC.DataFinalFolha   = (select max(PeC.DataFinalFolha)
                                  from PeriodoCalculo PeC
                                 where PeC.CodigoEmpresa  = PC.CodigoEmpresa
                                   and PeC.CodigoTipoCalc = PC.CodigoTipoCalc
                                   and PeC.Compet         = PC.Compet)
union
  select PC.CodigoTipoCalc,
         -1 as CadastroRetroativo,
         PC.Compet,
         PC.DataInicialFolha as DataFolha,
         PC.DataInicialVT    as DataVT,
         PC.CodigoPerCalculo
    from PeriodoCalculo PC
   where PC.CodigoEmpresa    = :CodigoEmpresa
     and PC.CodigoPerCalculo <> :CodigoPerCalculo
     and PC.Compet           = (select min(PeC.Compet)
                                  from PeriodoCalculo PeC
                                 where PeC.CodigoEmpresa  = PC.CodigoEmpresa
                                   and PeC.CodigoTipoCalc = PC.CodigoTipoCalc)
     and PC.DataFinalFolha   = (select min(PeC.DataFinalFolha)
                                  from PeriodoCalculo PeC
                                 where PeC.CodigoEmpresa  = PC.CodigoEmpresa
                                   and PeC.CodigoTipoCalc = PC.CodigoTipoCalc
                                   and PeC.Compet         = PC.Compet)
order by 1, 2, 3, 4