select C.CODIGOEMPRESA
     , C.CodigoFuncContr
     , C.TIPODESPESA
     , C.DATAINICIALFERIAS
     , RF.DataFinalFerias
     , RF.DataAbono
     , C.CODIGOOUTEMP
     , OE.NomeOutEmp
     , case when C.CODIGODEPEND is null then 'Titular' else 'Dependente' end as NomeBenef
     , SUM(C.VALOR) as Valor
     , SUM(C.VALORBENFEMP) as VALORBENFEMP
     , MAX(RF.DiasFerias) as DiasFerias
     , MAX(RF.DiasAbono) as DiasAbono
  from CALCULOFUNCPLANOSAUDE C
  join OUTRAEMPEMP OEE
    on OEE.codigoempresa = C.codigoempresa
   and OEE.CodigoOutEmp = C.CodigoOutEmp
  join OutraEmpresa OE
    on OE.CodigoOutEmp = OEE.CodigoOutEmp
  left join Periodocalculo PC
    on PC.CodigoEmpresa = C.CodigoEmpresa
   and PC.CodigoPerCalculo = C.CodigoPerCalculo
  left join reciboferias rf 
    on rf.codigoempresa = c.codigoempresa 
   and rf.CodigoFuncContr = c.CodigoFuncContr 
   and rf.datainicial = c.datainicial
   and rf.datainicialferias = c.datainicialferias
   and RF.seqreciboferias = C.seqreciboferias
  left join rescisao r 
    on r.codigoempresa = C.codigoempresa 
   and r.CodigoFuncContr = C.CodigoFuncContr
   and r.complementar = C.complementar
 where
       ((PC.Compet between :pDataInicial and :pDataFinal)
    or (R.DataResc between :pDataInicial and :pDataFinal and C.CodigoPerCalculo is null) 
    or (C.DataInicialFERIAS between :pDataInicial and :pDataFinal
    or rf.DataFinalFERIAS between :pDataInicial and :pDataFinal))
    and coalesce(C.SeqReciboFerias, 1) = 1 
    %0:s
 group by C.CODIGOEMPRESA
        , C.CodigoFuncContr
        , C.TIPODESPESA
        , C.DATAINICIALFERIAS
        , RF.DataFinalFerias
        , RF.DataAbono
        , C.CODIGOOUTEMP
        , OE.NomeOutEmp
        , case when C.CODIGODEPEND is null then 'Titular' else 'Dependente' end
 order by C.CODIGOEMPRESA
        , C.CodigoFuncContr
        , C.TIPODESPESA
        , C.DATAINICIALFERIAS
        , RF.DataFinalFerias
        , RF.DataAbono
        , C.CODIGOOUTEMP
        , OE.NomeOutEmp
        , NomeBenef DESC