SELECT FL.CODIGOESTAB,
       F.CodigoFuncContr,
       F.DATAINICIAL,
       F.DATAINICIALFERIAS,
       F.DATAFINALFERIAS,
       F.DIASFERIAS,
       F.DIASABONO,
       P.DIASFALTAS,
       P.DIASAFAST,
       E.CARGAHORDIARIA,
       (30 - (SELECT COALESCE(SUM(RF.DIASFERIAS), 0) FROM RECIBOFERIAS RF
               WHERE RF.CODIGOEMPRESA = F.CODIGOEMPRESA
                 AND RF.CodigoFuncContr = F.CodigoFuncContr
                 AND RF.DATAINICIAL = F.DATAINICIAL
                 AND RF.DATAINICIALFERIAS < F.DATAINICIALFERIAS)) DIASDIREITO
FROM RECIBOFERIAS F
JOIN PERIODOAQUIS P
  ON P.CODIGOEMPRESA = F.CODIGOEMPRESA
 AND P.CodigoFuncContr = F.CodigoFuncContr
 AND P.DATAINICIAL = F.DATAINICIAL
JOIN FUNCLOCAL FL
  ON FL.CODIGOEMPRESA = F.CODIGOEMPRESA
 AND FL.CodigoFuncContr = F.CodigoFuncContr
 AND FL.DATATRANSF = (SELECT MAX(FL1.DATATRANSF) FROM FUNCLOCAL FL1
                         WHERE FL1.CODIGOEMPRESA = F.CODIGOEMPRESA
                           AND FL1.CodigoFuncContr = F.CodigoFuncContr
                           AND FL1.DATATRANSF <= :pDataFinal)
JOIN FUNCESCALA FE
  ON FE.CODIGOEMPRESA = F.CODIGOEMPRESA
 AND FE.CodigoFuncContr = F.CodigoFuncContr
 AND FE.DATAINICIAL = (SELECT MAX(FE1.DATAINICIAL) FROM FUNCESCALA FE1
                         WHERE FE1.CODIGOEMPRESA = F.CODIGOEMPRESA
                           AND FE1.CodigoFuncContr = F.CodigoFuncContr
                           AND FE1.DATAINICIAL <= :pDataFinal)
JOIN ESCALA E
  ON E.CODIGOESCALA = FE.CODIGOESCALA
WHERE F.CODIGOEMPRESA = :pCodigoEmpresa
  AND (F.DATAINICIALFERIAS BETWEEN :pDataInicial AND :pDataFinal
    OR F.DATAFINALFERIAS BETWEEN :pDataInicial AND :pDataFinal)
ORDER BY FL.CODIGOESTAB,
       F.CodigoFuncContr,
       F.DATAINICIALFERIAS
