  select Rec.CodigoEmpresa,
         Rec.CodigoEstab,
         Rec.ClassifOrgan,
         Rec.CodigoOutEmp,
		 Rec.Seq,
		 Rec.NotaFiscal,
		 Rec.Serie,
		 Rec.DatarCto,	 
		 Rec.ChavelctoFisSai,
         sum(Recs.ValorRcto) sumValorRcto,
         sum(Recs.RetencGPS) sumRetencGPS
    from Recebimento Rec
    join RecebimentoServico Recs
      on (Rec.Codigoempresa = Recs.CodigoEmpresa
     and Rec.CodigoEstab = Recs.CodigoEstab
     and Rec.Compet = Recs.Compet
     and Rec.Seq = Recs.Seq)
   where Rec.CodigoEmpresa = :CodigoEmpresa
     and Rec.CodigoEstab = :CodigoEstab
     and Rec.Compet = :Compet
     and Rec.CompensarGPS = :CompensarGPS
     and (Rec.GPSOrigem between 1 and 3)
group by Rec.CodigoEmpresa,
         Rec.CodigoEstab,
         Rec.ClassifOrgan,
         Rec.CodigoOutEmp,
		 Rec.Seq,
		 Rec.NotaFiscal,
		 Rec.Serie,
		 Rec.DatarCto,	 
		 Rec.ChavelctoFisSai 
order by 1, 2, 3, 4