select R.CodigoOutEmp,
       O.NomeOutEmp,
       R.Seq,
       cast(sum(Rs.ValorRcto) as numeric(18,2)) ValorRcto,
       cast(sum(Rs.RetencGPS) as numeric(18,2)) RetencGPS,
       R.NotaFiscal,
       R.GPSOrigem
  from  Recebimento R
        JOIN RecebimentoServico Rs
          ON (R.CodigoEmpresa = Rs.CodigoEmpresa
         and R.CodigoEstab = Rs.CodigoEstab
         and R.Compet = Rs.Compet
         and R.Seq = Rs.Seq)
        LEFT OUTER JOIN OutraEmpEmp OEE
                     ON (R.CodigoEmpresa = OEE.CodigoEmpresa
                    and R.CodigoOutEmp = OEE.CodigoOutEmp)
        LEFT OUTER JOIN OutraEmpresa O
                     ON R.CodigoOutEmp = O.CodigoOutEmp
 where R.CodigoEmpresa = :pCodigoEmpresa
   and R.CodigoEstab = :pCodigoEstab
   and R.Compet = :pCompet
   and (OEE.PossuiGPS = '0' or R.CodigoOutEmp is null)
 group by R.CodigoOutEmp,
       O.nomeoutemp,
       R.Seq,
       R.NotaFiscal,
       R.GPSOrigem
 order by 2,
          1,
          3