select R.CodigoOutEmp,
       O.NomeOutEmp,
       R.Seq,
       sum(Rs.ValorRcto) ValorRcto,
       sum(Rs.RetencGPS) RetencGPS,
       R.NotaFiscal,
       R.GPSOrigem
  from  Recebimento R
        JOIN RecebimentoServico Rs
          ON (R.CodigoEmpresa = Rs.CodigoEmpresa
         and R.CodigoEstab = Rs.CodigoEstab
         and R.Compet = Rs.Compet
         and R.Seq = Rs.Seq)
        LEFT OUTER JOIN OutraEmpEmp OEE
                     ON (R.CodigoEmpresa = OEE.CodigoEmpresa
                    and R.CodigoOutEmp = OEE.CodigoOutEmp)
        LEFT OUTER JOIN OutraEmpresa O
                     ON R.CodigoOutEmp = O.CodigoOutEmp
 where R.CodigoEmpresa = :pCodigoEmpresa
   and R.CodigoEstab = :pCodigoEstab
   and R.Compet = :pCompet
   and R.ClassifOrgan = :pClassifOrgan
   and (OEE.PossuiGPS = 0 or R.CodigoOutEmp is null)
 group by R.CodigoOutEmp,
       O.NomeOutEmp,
       R.Seq,
       R.NotaFiscal,
       R.GPSOrigem
 order by 1,
          3