  select PA.DataInicial,
         PA.DataFinal,
         RF.DataInicialFerias,
         RF.DataFinalFerias,
         RF.DiasFerias,
         RF.DiasAbono,
         RF.DataAbono,
         case
           when RF.DataAbono is null then
             RF.DataAbono
           else
             cast({TIMESTAMPADD(DAY, (RF.DiasAbono - 1), RF.DataAbono)} as date)
         end DataFimAbono
    from ReciboFerias RF,
         PeriodoAquis PA
   where RF.CodigoEmpresa = :pCodigoEmpresa
     and RF.CodigoFuncContr = :pCodigoFuncContr
     and RF.TipoRecibo in (1, 2)
     and RF.SeqReciboFerias = 1
     and PA.CodigoEmpresa = RF.CodigoEmpresa
     and PA.CodigoFuncContr = RF.CodigoFuncContr
     and PA.DataInicial = RF.DataInicial
order by RF.DataInicialFerias Asc