 select PA.CodigoEmpresa,
        PA.CodigoFuncContr,
        PA.DataInicial,
        PA.DataFinal
   from  PeriodoAquis PA
   join FuncContrato F 
 	 on F.CodigoEmpresa    = PA.CodigoEmpresa
    and F.CodigoFuncContr  = PA.CodigoFuncContr
   join TipoContrato TC
	   on TC.CodigoTipoContr = F.CodigoTipoContr
   join DireitoFerias DF
     on DF.CodigoDirFerias = TC.CodigoDirFerias    
  where PA.CodigoEmpresa = %3:s
     and PA.CodigoFuncContr  = %4:s 
     and TC.CaTegeSocial in (107, 108)
     and (%0:s between PA.DataInicial and PA.DataFinal
      or (%1:s between PA.DataInicial and PA.DataFinal)
      or (PA.SitPeriodo = 1 and PA.DataFinal <= %0:s)
      or exists(select RF.DataInicial
                  from ReciboFerias RF
                 where RF.CodigoEmpresa = %3:s
                   and RF.CodigoFuncContr = %4:s 
                   and RF.DataInicial   = PA.DataInicial
						  and ((PA.DataInicial <= %1:s
						   and ((F.DataDem is not null
						   and ({TIMESTAMPADD(DAY, - {EXTRACT(DAY, F.DataDem)} + 1, F.DataDem)}) <> (cast(%0:s as date)))
						    or F.DataDem is null)
                           and ((RF.DataFinalFerias >= %0:s)
                            or RF.TipoRecibo = %2:s))

							or (((RF.DataInicialFerias between %0:s and %1:s)
                            or (RF.DataFinalFerias between %0:s and %1:s)
                            or (RF.DataInicialFerias < %0:s and RF.DataFinalFerias > %1:s)
							or ({TIMESTAMPADD(DAY, - {EXTRACT(DAY, F.DataDem)} + 1, F.DataDem)}) = (cast(%0:s as date))
							and RF.TipoRecibo = %2:s)))))
   order by 1, 2, 4