select E.CodigoEstrut,
         cast(sum(RE.ValorEvento) as numeric(16,2)) Valor
    from RescisaoEvento RE,
         Evento E
   where RE.CodigoEmpresa = :pCodigoEmpresa
     and RE.CodigoFuncContr = :pCodigoFuncContr
     and RE.CodigoEvento = E.CodigoEvento
     and (E.CodigoEstrut like '05.10%' or
          E.CodigoEstrut like '05.11%' or
          E.CodigoEstrut like '05.19%' or
          E.CodigoEstrut like '05.20%' or
          E.CodigoEstrut like '05.08%')
     and (not (E.TIPOEVENTO in (4,5,6,7)))
group by E.CodigoEstrut
order by 1

