 select T.CodigoTerc,
        T.CpfTerc, 
        sum(TB.BaseINSS) BaseINSS,
        sum(TB.ValorINSS) ValorINSS,
        sum(TB.BaseIRRF) BaseIRRF,
        sum(TB.ValorIRRF) ValorIRRF
   from TercOutContrBC TB
   Join Terceiro T
     on T.CodigoTerc = TB.CodigoTerc
  where TB.Compet = :pCompet
group by T.CodigoTerc,
         T.CpfTerc	
union  
 select  T.CodigoTerc,
         T.CpfTerc,
         sum(GPS.Valor) BaseINSS,
         sum(CONTRIBTERC.Valor) ValorINSS,
         sum(IRRF.Valor) BaseIRRF,
         sum(TP.PensaoJud) ValorIRRF
    from TerceiroPgto TP
   inner join Terceiro T 
      on T.CodigoTerc = TP.CodigoTerc
    left join TerceiroPgtoServico CONTRIBTERC
      on CONTRIBTERC.CodigoEmpresa = TP.CODIGOEMPRESA
      and CONTRIBTERC.CODIGOTERC = TP.CODIGOTERC
      and CONTRIBTERC.COMPET = TP.COMPET
      and CONTRIBTERC.SEQ = TP.SEQ
      and CONTRIBTERC.CodigoServico = 9057
    left join TerceiroPgtoServico GPS
      on GPS.CodigoEmpresa = TP.CODIGOEMPRESA
      and GPS.CODIGOTERC = TP.CODIGOTERC
      and GPS.COMPET = TP.COMPET
      and GPS.SEQ = TP.SEQ
      and GPS.CodigoServico = 9066
    left join TerceiroPgtoServico IRRF
      on IRRF.CodigoEmpresa = TP.CODIGOEMPRESA
      and IRRF.CODIGOTERC = TP.CODIGOTERC
      and IRRF.COMPET = TP.COMPET
      and IRRF.SEQ = TP.SEQ
      and IRRF.CodigoServico = 9067
   where TP.Compet = :pCompet
group by T.CodigoTerc,
         T.CpfTerc	 
order by 1, 2