/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.IOBridge;
import info.ata4.io.socket.IOSocket;
import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.io.EndianUtils;

public class DataInputBridge
extends IOBridge
implements DataInput {
    private final DataInput in;

    public DataInputBridge(IOSocket socket) {
        super(socket);
        this.in = socket.getDataInput();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        short r = this.in.readShort();
        if (this.isManualSwap()) {
            r = EndianUtils.swapShort((short)r);
        }
        return r;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int r = this.in.readUnsignedShort();
        if (this.isManualSwap()) {
            r = EndianUtils.swapShort((short)((short)r)) & 0xFFFF;
        }
        return r;
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        int r = this.in.readInt();
        if (this.isManualSwap()) {
            r = EndianUtils.swapInteger((int)r);
        }
        return r;
    }

    @Override
    public long readLong() throws IOException {
        long r = this.in.readLong();
        if (this.isManualSwap()) {
            r = EndianUtils.swapLong((long)r);
        }
        return r;
    }

    @Override
    public float readFloat() throws IOException {
        if (this.isManualSwap()) {
            return Float.intBitsToFloat(this.readInt());
        }
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        if (this.isManualSwap()) {
            return Double.longBitsToDouble(this.readLong());
        }
        return this.in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

