/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ByteBufferDataOutput
implements DataOutput {
    private final ByteBuffer buf;

    public ByteBufferDataOutput(ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.buf.put(b);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.buf.put(b, off, len);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        try {
            this.write(v ? 1 : 0);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        try {
            this.buf.put((byte)(v & 0xFF));
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        try {
            this.buf.putShort((short)(v & 0xFFFF));
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        try {
            this.buf.putChar((char)(v & 0xFFFF));
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        try {
            this.buf.putInt(v);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        try {
            this.buf.putLong(v);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        try {
            this.buf.putFloat(v);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        try {
            this.buf.putDouble(v);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    @Override
    public void writeChars(String s) throws IOException {
        try {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                this.writeChar(s.charAt(i));
            }
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.write(s.getBytes("UTF-8"));
    }
}

