/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;
    private int markPos;
    private int markReadLimit;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    @Override
    public int available() throws IOException {
        return this.buf.remaining();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.buf.mark();
        this.markPos = this.buf.position();
        this.markReadLimit = readLimit;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.buf.position() - this.markPos > this.markReadLimit) {
            throw new IOException("Invalid mark");
        }
        try {
            this.buf.reset();
        }
        catch (InvalidMarkException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        try {
            return 0xFF & this.buf.get();
        }
        catch (BufferUnderflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public synchronized int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        try {
            this.buf.get(bytes, off, len);
        }
        catch (BufferUnderflowException ex) {
            throw new IOException(ex);
        }
        return len;
    }
}

