/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private final ByteBuffer buf;

    public ByteBufferOutputStream(ByteBuffer buf) {
        if (buf.isReadOnly()) {
            throw new IllegalArgumentException("Buffer is read-only");
        }
        this.buf = buf;
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        try {
            this.buf.put((byte)b);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public synchronized void write(byte[] bytes, int off, int len) throws IOException {
        try {
            this.buf.put(bytes, off, len);
        }
        catch (BufferOverflowException ex) {
            throw new IOException(ex);
        }
    }
}

