/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.socket;

import info.ata4.io.SeekableImpl;
import info.ata4.io.buffer.ByteBufferDataInput;
import info.ata4.io.buffer.ByteBufferDataOutput;
import info.ata4.io.buffer.ByteBufferInputStream;
import info.ata4.io.buffer.ByteBufferOutputStream;
import info.ata4.io.socket.IOSocket;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSocket
extends IOSocket {
    private final ByteBuffer buf;

    public ByteBufferSocket(ByteBuffer buf) {
        this.buf = buf;
        this.setCanRead(true);
        this.setCanWrite(!buf.isReadOnly());
        this.setSeekable(new ByteBufferSeekable(buf));
        this.getDataInputProvider().set(new ByteBufferDataInput(buf));
        this.getDataOutputProvider().set(new ByteBufferDataOutput(buf));
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    @Override
    public ByteBufferInputStream getInputStream() {
        return new ByteBufferInputStream(this.buf);
    }

    @Override
    public ByteBufferOutputStream getOutputStream() {
        return new ByteBufferOutputStream(this.buf);
    }

    private class ByteBufferSeekable
    extends SeekableImpl {
        private final ByteBuffer buf;

        private ByteBufferSeekable(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public void position(long pos) throws IOException {
            if (pos > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Pointer is too large (> 2147483647)");
            }
            this.buf.position((int)pos);
        }

        @Override
        public long position() throws IOException {
            return this.buf.position();
        }

        @Override
        public long capacity() throws IOException {
            return this.buf.capacity();
        }

        @Override
        public boolean hasRemaining() throws IOException {
            return this.buf.hasRemaining();
        }

        @Override
        public long remaining() throws IOException {
            return this.buf.remaining();
        }
    }
}

