/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.socket;

import info.ata4.io.Seekable;
import info.ata4.io.socket.provider.DataInputProvider;
import info.ata4.io.socket.provider.DataOutputProvider;
import info.ata4.io.socket.provider.InputStreamProvider;
import info.ata4.io.socket.provider.OutputStreamProvider;
import info.ata4.io.socket.provider.ReadableByteChannelProvider;
import info.ata4.io.socket.provider.WritableByteChannelProvider;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IOSocket
implements Closeable {
    private InputStreamProvider isp;
    private OutputStreamProvider osp;
    private ReadableByteChannelProvider rbcp;
    private WritableByteChannelProvider wbcp;
    private DataInputProvider dip;
    private DataOutputProvider dop;
    private Seekable seekable;
    private boolean canRead;
    private boolean canWrite;

    protected InputStreamProvider getInputStreamProvider() {
        if (this.isp == null) {
            this.isp = new InputStreamProvider(this);
        }
        return this.isp;
    }

    protected OutputStreamProvider getOutputStreamProvider() {
        if (this.osp == null) {
            this.osp = new OutputStreamProvider(this);
        }
        return this.osp;
    }

    protected ReadableByteChannelProvider getReadableByteChannelProvider() {
        if (this.rbcp == null) {
            this.rbcp = new ReadableByteChannelProvider(this);
        }
        return this.rbcp;
    }

    protected WritableByteChannelProvider getWritableByteChannelProvider() {
        if (this.wbcp == null) {
            this.wbcp = new WritableByteChannelProvider(this);
        }
        return this.wbcp;
    }

    protected DataInputProvider getDataInputProvider() {
        if (this.dip == null) {
            this.dip = new DataInputProvider(this);
        }
        return this.dip;
    }

    protected DataOutputProvider getDataOutputProvider() {
        if (this.dop == null) {
            this.dop = new DataOutputProvider(this);
        }
        return this.dop;
    }

    public boolean canRead() {
        return this.canRead;
    }

    protected void setCanRead(boolean canRead) {
        this.canRead = canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    protected void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public InputStream getInputStream() {
        return (InputStream)this.getInputStreamProvider().get();
    }

    public OutputStream getOutputStream() {
        return (OutputStream)this.getOutputStreamProvider().get();
    }

    public DataInput getDataInput() {
        return (DataInput)this.getDataInputProvider().get();
    }

    public DataOutput getDataOutput() {
        return (DataOutput)this.getDataOutputProvider().get();
    }

    public ReadableByteChannel getReadableByteChannel() {
        return (ReadableByteChannel)this.getReadableByteChannelProvider().get();
    }

    public WritableByteChannel getWritableByteChannel() {
        return (WritableByteChannel)this.getWritableByteChannelProvider().get();
    }

    public ByteBuffer getByteBuffer() {
        return null;
    }

    public Seekable getSeekable() {
        return this.seekable;
    }

    protected void setSeekable(Seekable seekable) {
        this.seekable = seekable;
    }

    @Override
    public void close() throws IOException {
        this.close(this.isp);
        this.close(this.osp);
        this.close(this.rbcp);
        this.close(this.wbcp);
        this.close(this.dip);
        this.close(this.dop);
    }

    protected void close(Closeable c) throws IOException {
        if (c != null) {
            c.close();
        }
    }
}

