/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.socket.provider;

import info.ata4.io.socket.IOSocket;
import info.ata4.io.socket.provider.SocketProvider;
import info.ata4.io.streams.InverseDataInputStream;
import java.io.DataInput;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.input.CloseShieldInputStream;

public class InputStreamProvider
extends SocketProvider<InputStream> {
    public InputStreamProvider(IOSocket socket) {
        super(socket);
    }

    @Override
    protected InputStream create() {
        ReadableByteChannel chan = this.socket.getReadableByteChannel();
        if (chan != null) {
            return Channels.newInputStream(chan);
        }
        DataInput input = this.socket.getDataInput();
        if (input != null) {
            return new InverseDataInputStream(input);
        }
        return null;
    }

    @Override
    protected InputStream getCloseShield(InputStream instance) {
        return new CloseShieldInputStream(instance);
    }
}

