/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.socket.provider;

import info.ata4.io.socket.IOSocket;
import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;

public abstract class SocketProvider<T>
implements Closeable {
    protected final IOSocket socket;
    protected T shielded;
    protected T unshielded;

    public SocketProvider(IOSocket socket) {
        this.socket = socket;
    }

    protected T getCloseShield(T instance) {
        return instance;
    }

    protected abstract T create();

    public T get() {
        if (this.unshielded == null) {
            this.unshielded = this.create();
        }
        if (this.unshielded == null) {
            return this.unshielded;
        }
        this.shielded = this.getCloseShield(this.unshielded);
        return this.shielded;
    }

    public void set(T instance) {
        this.unshielded = instance;
    }

    protected void releaseShielded() {
        this.close(this.shielded);
        this.shielded = null;
    }

    protected void releaseUnshielded() {
        this.close(this.unshielded);
        this.unshielded = null;
    }

    protected void close(T o) {
        if (o == null) {
            return;
        }
        if (!(o instanceof Closeable)) {
            return;
        }
        Closeable c = (Closeable)o;
        IOUtils.closeQuietly((Closeable)c);
    }

    @Override
    public void close() throws IOException {
        this.releaseUnshielded();
        this.releaseShielded();
    }
}

