/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.streams;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class InverseDataInputStream
extends InputStream {
    private final DataInput in;

    public InverseDataInputStream(DataInput in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.in.readByte();
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            this.in.readFully(b);
            return b.length;
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.in.readFully(b, off, len);
            return len;
        }
        catch (EOFException ex) {
            return -1;
        }
    }
}

