/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.util;

import java.nio.ByteBuffer;

public class KMPMatch {
    private KMPMatch() {
    }

    public static int indexOf(ByteBuffer bb, byte[] pattern) {
        if (bb.remaining() < pattern.length) {
            return -1;
        }
        int[] failure = KMPMatch.computeFailure(pattern);
        int j = 0;
        while (bb.hasRemaining()) {
            byte b = bb.get();
            while (j > 0 && pattern[j] != b) {
                j = failure[j - 1];
            }
            if (pattern[j] == b) {
                ++j;
            }
            if (j != pattern.length) continue;
            return bb.position() - pattern.length;
        }
        return -1;
    }

    public int indexOf(byte[] data, byte[] pattern) {
        return KMPMatch.indexOf(ByteBuffer.wrap(data), pattern);
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

