/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ObjectToString {
    private static final ToStringStyle STYLE = new ObjectToStringStyle();

    public static String toString(Object obj) {
        return ReflectionToStringBuilder.toString((Object)obj, (ToStringStyle)STYLE);
    }

    private ObjectToString() {
    }

    private static class ObjectToStringStyle
    extends ToStringStyle {
        private static final String INDENT = "  ";
        private StringBuffer indentBuffer = new StringBuffer();

        ObjectToStringStyle() {
            this.setUseIdentityHashCode(false);
            this.setUseShortClassName(true);
            this.setArrayStart("[");
            this.setArrayEnd("]");
            this.setContentStart(" {");
            this.setFieldSeparatorAtStart(true);
            this.setFieldNameValueSeparator(" = ");
            this.updateSeparators();
        }

        private void indent() {
            this.indentBuffer.append(INDENT);
            this.updateSeparators();
        }

        private void unindent() {
            int len = this.indentBuffer.length();
            if (this.indentBuffer.length() > 0) {
                this.indentBuffer.setLength(len - INDENT.length());
            }
            this.updateSeparators();
        }

        protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            this.appendObject(buffer, value);
        }

        protected void appendDetail(StringBuffer buffer, String fieldName, Collection<?> coll) {
            this.indent();
            buffer.append(this.getArrayStart());
            buffer.append(this.getFieldSeparator());
            Iterator<?> it = coll.iterator();
            while (it.hasNext()) {
                this.appendObject(buffer, it.next());
                if (!it.hasNext()) continue;
                buffer.append(this.getArraySeparator());
                buffer.append(this.getFieldSeparator());
            }
            this.unindent();
            buffer.append(this.getFieldSeparator());
            buffer.append(this.getArrayEnd());
        }

        protected void appendDetail(StringBuffer buffer, String fieldName, Map<?, ?> map) {
            this.indent();
            buffer.append(this.getArrayStart());
            buffer.append(this.getFieldSeparator());
            Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<?, ?> entry = it.next();
                this.appendObject(buffer, entry.getKey());
                buffer.append(this.getFieldNameValueSeparator());
                this.appendObject(buffer, entry.getValue());
                if (!it.hasNext()) continue;
                buffer.append(this.getArraySeparator());
                buffer.append(this.getFieldSeparator());
            }
            this.unindent();
            buffer.append(this.getFieldSeparator());
            buffer.append(this.getArrayEnd());
        }

        private void appendObject(StringBuffer buffer, Object obj) {
            if (this.hasDefaultToString(obj)) {
                this.indent();
                buffer.append(ReflectionToStringBuilder.toString((Object)obj, (ToStringStyle)this));
                this.unindent();
            } else {
                buffer.append(obj);
            }
        }

        private boolean hasDefaultToString(Object obj) {
            try {
                return obj.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class;
            }
            catch (SecurityException ex) {
                return false;
            }
            catch (NoSuchMethodException ex) {
                return true;
            }
        }

        private void updateSeparators() {
            String indentGlobal = this.indentBuffer.toString();
            this.setFieldSeparator(SystemUtils.LINE_SEPARATOR + indentGlobal + INDENT);
            this.setContentEnd(SystemUtils.LINE_SEPARATOR + indentGlobal + "}");
        }
    }
}

