/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;

class ConcurrentBufferOutputStream
extends OutputStream {
    protected ArrayBlockingQueue<byte[]> q;
    static final int BUFSIZE = 16384;
    static final int QUEUESIZE = 4096;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    private ConcurrentBufferOutputStream(ArrayBlockingQueue<byte[]> q) {
        if (DEBUG) {
            dbg.printf("%s >> %s%n", this, q);
        }
        this.q = q;
    }

    static OutputStream create(ArrayBlockingQueue<byte[]> q) {
        OutputStream out = new ConcurrentBufferOutputStream(q);
        out = new BufferedOutputStream(out, 16384);
        return out;
    }

    static ArrayBlockingQueue<byte[]> newQueue() {
        return new ArrayBlockingQueue<byte[]>(4096);
    }

    protected void guarded_put(byte[] a) throws IOException {
        try {
            this.q.put(a);
        }
        catch (InterruptedException exn) {
            throw new InterruptedIOException(exn.getMessage());
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)(i & 0xFF)};
        this.guarded_put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] a = new byte[len];
        System.arraycopy(b, off, a, 0, len);
        this.guarded_put(a);
    }

    @Override
    public void close() throws IOException {
        if (DEBUG) {
            dbg.printf("%s closed%n", this);
        }
        byte[] b = new byte[]{};
        this.guarded_put(b);
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_ConcurrentBuffer");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

