/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import lzma.LzmaDecoder;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;
import net.contrapunctus.lzma.LzmaOutputStream;

class DecoderThread
extends Thread {
    protected ArrayBlockingQueue<byte[]> q = ConcurrentBufferOutputStream.newQueue();
    protected InputStream in;
    protected OutputStream out;
    protected LzmaDecoder dec;
    protected IOException exn;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;
    static final int propSize = 5;
    static final byte[] props;

    DecoderThread(InputStream _in) {
        this.in = _in;
        this.out = ConcurrentBufferOutputStream.create(this.q);
        this.dec = new LzmaDecoder();
        this.exn = null;
        if (DEBUG) {
            dbg.printf("%s >> %s (%s)%n", this, this.out, this.q);
        }
    }

    @Override
    public void run() {
        block11: {
            try {
                long outSize = 0L;
                if (LzmaOutputStream.LZMA_HEADER) {
                    int n = this.in.read(props, 0, 5);
                    if (n != 5) {
                        throw new IOException("input .lzma file is too short");
                    }
                    this.dec.setDecoderProperties(props);
                    for (int i = 0; i < 8; ++i) {
                        int v = this.in.read();
                        if (v < 0) {
                            throw new IOException("Can't read stream size");
                        }
                        outSize |= (long)v << 8 * i;
                    }
                } else {
                    outSize = -1L;
                    this.dec.setDecoderProperties(props);
                }
                if (DEBUG) {
                    dbg.printf("%s begins%n", this);
                }
                this.dec.code(this.in, this.out, outSize);
                if (DEBUG) {
                    dbg.printf("%s ends%n", this);
                }
                this.in.close();
            }
            catch (IOException _exn) {
                this.exn = _exn;
                if (!DEBUG) break block11;
                dbg.printf("%s exception: %s%n", this, this.exn.getMessage());
            }
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void maybeThrow() throws IOException {
        if (this.exn != null) {
            throw this.exn;
        }
    }

    @Override
    public String toString() {
        return String.format("Dec@%x", this.hashCode());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaCoders");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
        props = new byte[5];
        DecoderThread.props[0] = 93;
        DecoderThread.props[1] = 0;
        DecoderThread.props[2] = 0;
        DecoderThread.props[3] = 16;
        DecoderThread.props[4] = 0;
    }
}

