/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;
import net.contrapunctus.lzma.EncoderThread;

public class LzmaOutputStream
extends FilterOutputStream {
    public static boolean LZMA_HEADER = true;
    private EncoderThread eth;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    public LzmaOutputStream(OutputStream _out) {
        this(_out, EncoderThread.DEFAULT_DICT_SZ_POW2, null);
    }

    public LzmaOutputStream(OutputStream _out, Integer dictSzPow2, Integer fastBytes) {
        super(null);
        this.eth = new EncoderThread(_out, dictSzPow2, fastBytes);
        this.out = ConcurrentBufferOutputStream.create(this.eth.q);
        if (DEBUG) {
            dbg.printf("%s >> %s (%s)%n", this, this.out, this.eth.q);
        }
        this.eth.start();
    }

    @Override
    public void write(int i) throws IOException {
        if (this.eth.exn != null) {
            throw this.eth.exn;
        }
        this.out.write(i);
    }

    @Override
    public void close() throws IOException {
        if (DEBUG) {
            dbg.printf("%s closed%n", this);
        }
        this.out.close();
        try {
            this.eth.join();
            if (DEBUG) {
                dbg.printf("%s joined %s%n", this, this.eth);
            }
        }
        catch (InterruptedException exn) {
            throw new InterruptedIOException(exn.getMessage());
        }
        if (this.eth.exn != null) {
            throw this.eth.exn;
        }
    }

    public String toString() {
        return String.format("lzmaOut@%x", this.hashCode());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaStreams");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

