/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.asset.bundle.codec;

import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.unity.asset.bundle.codec.AssetBundleCodec;
import java.nio.ByteBuffer;
import javax.xml.bind.DatatypeConverter;

public class XianjianCodec
implements AssetBundleCodec {
    private static final byte[] KEY = DatatypeConverter.parseHexBinary((String)"56F45921699978FC92B3");

    @Override
    public String getName() {
        return "Xianjian XOR";
    }

    @Override
    public boolean isEncoded(ByteBuffer bb) {
        return bb.get(32) == KEY[5] && bb.get(64) == KEY[6];
    }

    @Override
    public ByteBuffer encode(ByteBuffer bb) {
        if (bb.isReadOnly()) {
            bb = ByteBufferUtils.copy((ByteBuffer)bb);
        }
        int exp = 5;
        while (1 << exp < bb.limit()) {
            int offset = 1 << exp;
            int b = bb.get(offset) & 0xFF;
            bb.put(offset, (byte)(b ^= KEY[exp % KEY.length]));
            ++exp;
        }
        return bb;
    }

    @Override
    public ByteBuffer decode(ByteBuffer bb) {
        return this.encode(bb);
    }
}

