/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.asset.struct;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import java.io.IOException;
import java.util.UUID;

public class AssetRef
implements Struct {
    private UUID guid;
    private String filePath;
    private String assetPath;
    private int type;

    public void read(DataInputReader in) throws IOException {
        boolean swap = in.isSwap();
        in.setSwap(false);
        long guidMost = in.readLong();
        long guidLeast = in.readLong();
        in.setSwap(swap);
        this.guid = new UUID(guidMost, guidLeast);
        this.type = in.readInt();
        this.filePath = in.readStringNull();
        this.assetPath = in.readStringNull();
    }

    public void write(DataOutputWriter out) throws IOException {
        boolean swap = out.isSwap();
        out.setSwap(false);
        out.writeLong(this.guid.getMostSignificantBits());
        out.writeLong(this.guid.getLeastSignificantBits());
        out.setSwap(swap);
        out.writeInt(this.type);
        out.writeStringNull(this.filePath);
        out.writeStringNull(this.assetPath);
    }

    public UUID getGUID() {
        return this.guid;
    }

    public void setGUID(UUID guid) {
        this.guid = guid;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getAssetPath() {
        return this.assetPath;
    }

    public void setAssetPath(String assetPath) {
        this.assetPath = assetPath;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

