/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import info.ata4.io.file.FilenameSanitizer;
import info.ata4.io.util.PathUtils;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.bundle.AssetBundle;
import info.ata4.unity.cli.cmd.FileCommand;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public abstract class AssetCommand
extends FileCommand {
    private static final Logger L = LogUtils.getLogger();
    private Path outputDir;
    private boolean processAssets = true;
    private boolean processBundledAssets = true;
    private boolean processBundles = true;

    protected Path getOutputDir() {
        return this.outputDir;
    }

    protected void setOutputDir(Path path) {
        if (this.outputDir != null && PathUtils.isDirectoryEmpty((Path)this.outputDir)) {
            PathUtils.deleteQuietly((Path)this.outputDir);
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            path = PathUtils.append((Path)path, (String)"_");
        }
        this.outputDir = path;
    }

    protected boolean isProcessAssets() {
        return this.processAssets;
    }

    protected void setProcessAssets(boolean processAssets) {
        this.processAssets = processAssets;
    }

    protected boolean isProcessBundledAssets() {
        return this.processBundledAssets;
    }

    protected void setProcessBundledAssets(boolean processBundledAssets) {
        this.processBundledAssets = processBundledAssets;
    }

    protected boolean isProcessBundles() {
        return this.processBundles;
    }

    protected void setProcessBundles(boolean processBundles) {
        this.processBundles = processBundles;
    }

    @Override
    protected void processFile(Path file) throws IOException {
        if (AssetBundle.isAssetBundle(file)) {
            if (this.processBundles) {
                this.processAssetBundleFile(file);
            }
        } else if (this.processAssets) {
            this.processAssetFile(file);
        }
    }

    protected void processAssetFile(Path file) throws IOException {
        AssetFile asset = new AssetFile();
        asset.open(file);
        this.setOutputDir(PathUtils.removeExtension((Path)file));
        this.processAsset(asset);
    }

    protected void processAssetBundleFile(Path file) throws IOException {
        AssetBundle ab = new AssetBundle();
        ab.open(file);
        Path outDir = PathUtils.removeExtension((Path)file);
        this.setOutputDir(outDir);
        this.processAssetBundle(ab);
        if (this.processAssets && this.processBundledAssets) {
            for (Map.Entry<String, ByteBuffer> entry : ab.getEntries().entrySet()) {
                String[] names;
                String pathString = entry.getKey();
                if (pathString.endsWith(".dll") || pathString.endsWith(".mdb") || pathString.equals("33Obf")) continue;
                Path path = outDir;
                for (String name : names = StringUtils.split(pathString, '/')) {
                    path = path.resolve(FilenameSanitizer.sanitizeName((String)name));
                }
                L.log(Level.INFO, "{0}{1}{2}", new Object[]{file.toString(), file.getFileSystem().getSeparator(), pathString});
                ByteBuffer bb = entry.getValue();
                AssetFile asset = new AssetFile();
                asset.load(bb);
                asset.setSourceBundle(ab);
                this.setOutputDir(PathUtils.removeExtension((Path)path));
                this.processAsset(asset);
            }
        }
    }

    protected void processAsset(AssetFile asset) throws IOException {
    }

    protected void processAssetBundle(AssetBundle bundle) throws IOException {
    }
}

