/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.cli.cmd.AssetCommand;
import info.ata4.unity.serdes.Deserializer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Parameters(commandNames={"debug-deserializer"}, commandDescription="Performs an asset deserialization test.")
public class DebugDeserializerCmd
extends AssetCommand {
    private static final Logger L = LogUtils.getLogger();
    private int objTested;
    private int objFailed;

    @Override
    protected void processAsset(AssetFile asset) throws IOException {
        Deserializer deser = new Deserializer(asset);
        int objTestedAsset = 0;
        for (ObjectPath path : asset.getPaths()) {
            block5: {
                if (path.isScript()) continue;
                try {
                    deser.deserialize(path);
                }
                catch (Exception ex) {
                    L.log(Level.INFO, "Deserialization failed for " + path, ex);
                    ++this.objFailed;
                    if (!this.getOptions().isVerbose()) break block5;
                    deser.setDebug(true);
                    try {
                        deser.deserialize(path);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    deser.setDebug(false);
                }
            }
            ++objTestedAsset;
            ++this.objTested;
        }
        L.log(Level.INFO, "Tested objects: {0}", objTestedAsset);
    }

    @Override
    protected void processEnd() {
        L.log(Level.INFO, "Total tested objects: {0}", this.objTested);
        if (this.objFailed == 0) {
            L.log(Level.INFO, "All objects successfully deserialized!");
        } else {
            L.log(Level.INFO, "Failed deserializations: {0}", this.objFailed);
        }
    }
}

