/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.log.LogUtils;
import info.ata4.unity.cli.cmd.Command;
import info.ata4.unity.serdes.db.FieldTypeMap;
import info.ata4.unity.serdes.db.StructDatabase;
import info.ata4.unity.util.ClassID;
import info.ata4.unity.util.UnityVersion;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Parameters(commandNames={"debug-structdb"}, commandDescription="Shows structure database stats.")
public class DebugStructDBCmd
extends Command {
    private static final Logger L = LogUtils.getLogger();

    @Override
    public void run() {
        FieldTypeMap ftm = StructDatabase.getInstance().getFieldTypeMap();
        HashSet fieldNodes = new HashSet();
        TreeSet versions = new TreeSet();
        TreeSet classIDs = new TreeSet();
        for (Map.Entry entry : ftm.entrySet()) {
            versions.add(((Pair)entry.getKey()).getRight());
            classIDs.add(((Pair)entry.getKey()).getLeft());
            fieldNodes.add(entry.getValue());
        }
        L.log(Level.INFO, "Class IDs: {0}", classIDs.size());
        L.log(Level.INFO, "Versions: {0}", versions.size());
        L.log(Level.INFO, "Fields: {0}", fieldNodes.size());
        System.out.println();
        System.out.print("        |");
        for (Integer classID : classIDs) {
            System.out.print(StringUtils.leftPad(String.valueOf(classID), 4));
            System.out.print(" |");
        }
        System.out.println();
        System.out.print("--------|");
        System.out.print(StringUtils.repeat("-----|", classIDs.size()));
        System.out.println();
        for (UnityVersion rev : versions) {
            System.out.print(rev);
            System.out.print(" |");
            for (Integer classID : classIDs) {
                System.out.print("  ");
                if (ftm.containsKey(new ImmutablePair<Integer, UnityVersion>(classID, rev))) {
                    System.out.print("x");
                } else {
                    System.out.print(" ");
                }
                System.out.print("  |");
            }
            System.out.println();
        }
        System.out.println();
        for (Integer classID : classIDs) {
            String className = ClassID.getNameForID(classID);
            String classIDStr = StringUtils.rightPad(String.valueOf(classID), 3);
            if (className == null) {
                System.out.printf("%s : ???\n", classIDStr);
                continue;
            }
            System.out.printf("%s : %s\n", classIDStr, className);
        }
    }
}

