/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameter;
import info.ata4.log.LogUtils;
import info.ata4.unity.cli.cmd.Command;
import info.ata4.unity.cli.converters.PathConverter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FileCommand
extends Command {
    private static final Logger L = LogUtils.getLogger();
    @Parameter(description="<file> [file]...", converter=PathConverter.class, required=true)
    private List<Path> files;

    protected abstract void processFile(Path var1) throws IOException;

    protected void processDirectory(Path dir) throws IOException {
        boolean allowDirs = this.getOptions().isRecursive();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
            for (Path path : directoryStream) {
                this.processPath(path, allowDirs);
            }
        }
    }

    protected void processPath(Path path, boolean allowDirs) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (allowDirs) {
                    L.info(path.toString());
                    this.processDirectory(path);
                }
            } else {
                L.info(path.toString());
                this.processFile(path);
            }
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Can't process " + path, ex);
        }
    }

    protected void processEnd() {
    }

    @Override
    public void run() {
        for (Path file : this.files) {
            if (Files.notExists(file, new LinkOption[0])) {
                L.log(Level.WARNING, "File not found: {0}", file);
                continue;
            }
            this.processPath(file, true);
        }
        this.processEnd();
    }
}

