/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.cli.cmd.AssetCommand;
import info.ata4.unity.serdes.db.StructDatabase;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Parameters(commandNames={"learn"}, commandDescription="Copies new structure information to database.")
public class LearnCmd
extends AssetCommand {
    private static final Logger L = LogUtils.getLogger();

    @Override
    public void processAsset(AssetFile asset) throws IOException {
        int learned = StructDatabase.getInstance().learn(asset);
        if (learned > 0) {
            L.log(Level.INFO, "Learned {0} new structs", learned);
        } else {
            L.log(Level.INFO, "Nothing new learned");
        }
    }

    @Override
    public void processEnd() {
        StructDatabase.getInstance().update();
    }
}

