/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.cli.cmd.AssetCommand;
import info.ata4.unity.util.ClassID;
import info.ata4.util.collection.MapUtils;
import info.ata4.util.string.StringUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Parameters(commandNames={"info-stats"}, commandDescription="Shows class usage stats.")
public class StatsCmd
extends AssetCommand {
    private final PrintStream ps;

    public StatsCmd(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    protected void processAsset(AssetFile asset) throws IOException {
        List<ObjectPath> paths = asset.getPaths();
        HashMap<String, Integer> classCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> classSizes = new HashMap<String, Integer>();
        for (ObjectPath path : paths) {
            String className = ClassID.getNameForID(path.getClassID(), true);
            if (!classCounts.containsKey(className)) {
                classCounts.put(className, 0);
                classSizes.put(className, 0);
            }
            classCounts.put(className, (Integer)classCounts.get(className) + 1);
            classSizes.put(className, (Integer)classSizes.get(className) + path.getLength());
        }
        this.ps.println("Classes by object instances:");
        Map classCountsSorted = MapUtils.sortByValue(classCounts, true);
        for (Map.Entry entry : classCountsSorted.entrySet()) {
            String className = (String)entry.getKey();
            int classCount = (Integer)entry.getValue();
            this.ps.printf("  %s: %d\n", className, classCount);
        }
        this.ps.println("Classes by object data size:");
        Map classSizesSorted = MapUtils.sortByValue(classSizes, true);
        for (Map.Entry entry : classSizesSorted.entrySet()) {
            String className = (String)entry.getKey();
            String classSize = StringUtils.humanReadableByteCount(((Integer)entry.getValue()).intValue(), true);
            this.ps.printf("  %s: %s\n", className, classSize);
        }
        this.ps.println();
    }
}

