/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.converters;

import com.beust.jcommander.IStringConverter;
import info.ata4.log.LogUtils;
import info.ata4.unity.util.ClassID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassIDConverter
implements IStringConverter<Integer> {
    private static final Logger L = LogUtils.getLogger();

    public Integer convert(String value) {
        Integer classID;
        try {
            classID = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            classID = ClassID.getIDForName(value, true);
        }
        if (classID == null) {
            L.log(Level.WARNING, "Invalid class name or ID: {0}", value);
        }
        return classID;
    }
}

