/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.dump;

import info.ata4.log.LogUtils;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.asset.struct.TypeField;
import info.ata4.unity.asset.struct.TypeTree;
import info.ata4.unity.cli.classfilter.ClassFilter;
import info.ata4.unity.serdes.Deserializer;
import info.ata4.unity.serdes.UnityObject;
import info.ata4.unity.serdes.UnityTag;
import info.ata4.unity.util.ClassID;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class AssetDumper {
    private static final Logger L = LogUtils.getLogger();
    private static final String INDENT_STRING = "  ";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final AssetFile asset;
    private ClassFilter cf;
    private Path outputDir;
    private int indentLevel;
    private PrintWriter pw;

    public AssetDumper(AssetFile asset) {
        this.asset = asset;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public ClassFilter getClassFilter() {
        return this.cf;
    }

    public void setClassFilter(ClassFilter cf) {
        this.cf = cf;
    }

    public void dumpData() throws IOException {
        Deserializer deser = new Deserializer(this.asset);
        for (ObjectPath path : this.asset.getPaths()) {
            UnityObject obj;
            if (path.isScript() || this.cf != null && !this.cf.accept(path)) continue;
            try {
                obj = deser.deserialize(path);
            }
            catch (Exception ex) {
                L.log(Level.SEVERE, "Deserialization failed for " + path, ex);
                continue;
            }
            if (this.outputDir != null) {
                String className = ClassID.getNameForID(path.getClassID(), true);
                Path classDir = this.outputDir.resolve(className);
                if (Files.notExists(classDir, new LinkOption[0])) {
                    Files.createDirectories(classDir, new FileAttribute[0]);
                }
                String fileName = String.format("%06d.txt", path.getPathID());
                Path dumpFile = classDir.resolve(fileName);
                L.log(Level.FINE, "Writing {0}", fileName);
                BufferedWriter writer = Files.newBufferedWriter(dumpFile, CHARSET, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    this.pw = new PrintWriter(writer);
                    this.dumpObject(obj);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                    continue;
                }
            }
            this.pw = new PrintWriter(System.out);
            this.dumpObject(obj);
            this.pw.flush();
        }
    }

    public void dumpObject(UnityObject obj) {
        this.pw.print(obj.getType());
        if (!obj.getName().equals("Base")) {
            this.pw.print(" ");
            this.pw.println(obj.getName());
        } else {
            this.pw.println();
        }
        ++this.indentLevel;
        for (Map.Entry field : obj.get().entrySet()) {
            this.indent();
            this.dumpField((String)field.getKey(), (UnityTag)field.getValue());
        }
        --this.indentLevel;
    }

    public void dumpField(String name, UnityTag value) {
        if (!(value.get() instanceof UnityObject)) {
            this.pw.printf("%s %s = ", value.getType(), name);
        }
        this.dumpValue(value.get());
    }

    private void dumpValue(Object value) {
        if (value instanceof UnityObject) {
            UnityObject obj = (UnityObject)value;
            this.dumpObject(obj);
        } else if (value instanceof UnityTag) {
            UnityTag val = (UnityTag)value;
            Object valObj = val.get();
            if (valObj instanceof List) {
                this.dumpList(val, valObj);
            } else {
                this.dumpValue(valObj);
            }
        } else if (value instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)value;
            this.pw.printf("byte[%d]\n", bb.capacity());
            this.dumpBytes(bb);
        } else if (value instanceof String) {
            this.pw.printf("\"%s\"\n", value);
        } else {
            this.pw.printf("%s\n", value);
        }
    }

    private void dumpBytes(ByteBuffer bb) {
        byte[] block = new byte[256];
        ByteBuffer bb2 = bb.duplicate();
        bb2.rewind();
        ++this.indentLevel;
        while (bb2.hasRemaining()) {
            byte[] blockPrint;
            int len = Math.min(bb2.remaining(), block.length);
            bb2.get(block, 0, len);
            if (len != block.length) {
                blockPrint = new byte[len];
                System.arraycopy(block, 0, blockPrint, 0, len);
            } else {
                blockPrint = block;
            }
            this.indent();
            this.pw.println(DatatypeConverter.printHexBinary((byte[])blockPrint));
        }
        --this.indentLevel;
    }

    private void dumpList(UnityTag value, Object obj) {
        List list = (List)obj;
        this.pw.printf("%s[%d]\n", value.getType(), list.size());
        ++this.indentLevel;
        for (Object valueInner : list) {
            this.indent();
            this.dumpValue(valueInner);
        }
        --this.indentLevel;
    }

    public void dumpStruct() throws IOException {
        TypeTree typeTree = this.asset.getTypeTree();
        if (typeTree.getFields().isEmpty()) {
            L.info("No type tree available");
            return;
        }
        Set<Integer> classIDs = this.asset.getClassIDs();
        for (Integer classID : classIDs) {
            TypeField classField = typeTree.getFields().get(classID);
            if (this.cf != null && !this.cf.accept(classID) || classField == null) continue;
            if (this.outputDir != null) {
                if (Files.notExists(this.outputDir, new LinkOption[0])) {
                    Files.createDirectories(this.outputDir, new FileAttribute[0]);
                }
                String className = ClassID.getNameForID(classID, true);
                String fileName = String.format("%s.txt", className);
                Path file = this.outputDir.resolve(fileName);
                BufferedWriter writer = Files.newBufferedWriter(file, CHARSET, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    this.pw = new PrintWriter(writer);
                    this.dumpType(classField);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                    continue;
                }
            }
            this.pw = new PrintWriter(System.out);
            this.dumpType(classField);
            this.pw.flush();
        }
    }

    private void dumpType(TypeField field) {
        String name = field.getName();
        String type = field.getType();
        this.indent();
        this.pw.print(type);
        if (!name.equals("Base")) {
            this.pw.print(" ");
            this.pw.println(name);
        } else {
            this.pw.println();
        }
        ++this.indentLevel;
        for (TypeField subField : field.getChildren()) {
            this.dumpType(subField);
        }
        --this.indentLevel;
    }

    private void indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.pw.print(INDENT_STRING);
        }
    }
}

