/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract;

import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.io.file.FilenameSanitizer;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.serdes.UnityObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public abstract class AssetExtractHandler {
    private static final Logger L = LogUtils.getLogger();
    private AssetFile asset;
    private ObjectPath path;
    private String className;
    private Path outDir;
    private String outFileName;
    private String outFileExt;
    private final Set<Path> uniqueFiles = new HashSet<Path>();

    public AssetFile getAssetFile() {
        return this.asset;
    }

    public void setAssetFile(AssetFile asset) {
        this.asset = asset;
    }

    public Path getOutputDir() {
        return this.outDir;
    }

    public void setOutputDir(Path outDir) {
        this.outDir = outDir;
        this.uniqueFiles.clear();
    }

    public String getOutputFileExtension() {
        return this.outFileExt;
    }

    public void setOutputFileExtension(String outFileExt) {
        this.outFileExt = outFileExt;
    }

    public String getOutputFileName() {
        return this.outFileName;
    }

    public void setOutputFileName(String outFileName) {
        this.outFileName = FilenameSanitizer.sanitizeName((String)outFileName);
    }

    public ObjectPath getObjectPath() {
        return this.path;
    }

    public void setObjectPath(ObjectPath path) {
        this.path = path;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public abstract void extract(UnityObject var1) throws IOException;

    protected void writeData(ByteBuffer bb) throws IOException {
        Path outFile = this.getOutputFile();
        try {
            ByteBufferUtils.save((Path)outFile, (ByteBuffer)bb);
        }
        catch (IOException ex) {
            L.log(Level.WARNING, "Failed writing " + outFile, ex);
        }
    }

    protected void writeData(byte[] data) throws IOException {
        this.writeData(ByteBuffer.wrap(data));
    }

    protected Path getOutputFile() throws IOException {
        Path classDir = this.getOutputDir().resolve(this.getClassName());
        if (Files.notExists(classDir, new LinkOption[0])) {
            Files.createDirectories(classDir, new FileAttribute[0]);
        }
        String fileName = this.getOutputFileName();
        String fileExt = this.getOutputFileExtension();
        if (StringUtils.isBlank(fileName)) {
            fileName = String.format("%06d", this.getObjectPath().getPathID());
        }
        if (StringUtils.isBlank(fileExt)) {
            fileExt = "bin";
        }
        Path assetFile = this.getUniqueFile(classDir, fileName, fileExt);
        L.log(Level.INFO, "Writing {0} {1}", new Object[]{this.getClassName(), assetFile.getFileName()});
        return assetFile;
    }

    private Path getUniqueFile(Path parent, String name, String ext) {
        Path file = parent.resolve(String.format("%s.%s", name, ext));
        int fileNum = 1;
        while (this.uniqueFiles.contains(file)) {
            file = parent.resolve(String.format("%s_%d.%s", name, fileNum, ext));
            ++fileNum;
        }
        this.uniqueFiles.add(file);
        return file;
    }
}

