/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract;

import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.io.file.FilenameSanitizer;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.asset.struct.TypeTree;
import info.ata4.unity.cli.classfilter.ClassFilter;
import info.ata4.unity.cli.extract.AssetExtractHandler;
import info.ata4.unity.cli.extract.AudioClipHandler;
import info.ata4.unity.cli.extract.FontHandler;
import info.ata4.unity.cli.extract.MovieTextureHandler;
import info.ata4.unity.cli.extract.SubstanceArchiveHandler;
import info.ata4.unity.cli.extract.TextAssetHandler;
import info.ata4.unity.cli.extract.Texture2DHandler;
import info.ata4.unity.cli.extract.mesh.MeshHandler;
import info.ata4.unity.serdes.Deserializer;
import info.ata4.unity.serdes.UnityObject;
import info.ata4.unity.util.ClassID;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AssetExtractor {
    private static final Logger L = LogUtils.getLogger();
    private final AssetFile asset;
    private final Map<String, AssetExtractHandler> extractHandlerMap = new HashMap<String, AssetExtractHandler>();
    private ClassFilter cf;
    private Path outputDir;

    public static String getObjectName(AssetFile asset, ObjectPath path) {
        Deserializer deser = new Deserializer(asset);
        String name = null;
        try {
            UnityObject obj = deser.deserialize(path);
            name = (String)obj.getValue("m_Name");
        }
        catch (OutOfMemoryError ex) {
            deser = null;
            System.gc();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return name;
    }

    public AssetExtractor(AssetFile asset) {
        this.asset = asset;
        this.addHandler("AudioClip", new AudioClipHandler());
        this.addHandler("Shader", new TextAssetHandler("shader"));
        this.addHandler("SubstanceArchive", new SubstanceArchiveHandler());
        this.addHandler("Texture2D", new Texture2DHandler());
        this.addHandler("Cubemap", new Texture2DHandler());
        this.addHandler("Font", new FontHandler());
        this.addHandler("TextAsset", new TextAssetHandler("txt"));
        this.addHandler("MovieTexture", new MovieTextureHandler());
        this.addHandler("Mesh", new MeshHandler());
    }

    public final void addHandler(String className, AssetExtractHandler handler) {
        handler.setClassName(className);
        this.extractHandlerMap.put(className, handler);
    }

    public final AssetExtractHandler getHandler(String className) {
        return this.extractHandlerMap.get(className);
    }

    public final void clearHandlers() {
        this.extractHandlerMap.clear();
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public ClassFilter getClassFilter() {
        return this.cf;
    }

    public void setClassFilter(ClassFilter cf) {
        this.cf = cf;
    }

    public void extract(boolean raw) throws IOException {
        List<ObjectPath> paths = this.asset.getPaths();
        Deserializer deser = new Deserializer(this.asset);
        for (AssetExtractHandler extractHandler : this.extractHandlerMap.values()) {
            extractHandler.setAssetFile(this.asset);
            extractHandler.setOutputDir(this.outputDir);
        }
        for (ObjectPath path : paths) {
            UnityObject obj;
            if (this.cf != null && !this.cf.accept(path)) continue;
            String className = ClassID.getNameForID(path.getClassID(), true);
            if (raw) {
                String assetFileName = String.format("%06d.bin", path.getPathID());
                Path classDir = this.outputDir.resolve(className);
                if (Files.notExists(classDir, new LinkOption[0])) {
                    Files.createDirectories(classDir, new FileAttribute[0]);
                }
                Path assetFile = classDir.resolve(assetFileName);
                L.log(Level.INFO, "Writing {0} {1}", new Object[]{className, assetFileName});
                ByteBuffer bbAsset = this.asset.getPathBuffer(path);
                try {
                    ByteBufferUtils.save((Path)assetFile, (ByteBuffer)bbAsset);
                }
                catch (Exception ex) {
                    L.log(Level.WARNING, "Can't write " + path + " to " + assetFile, ex);
                }
                continue;
            }
            AssetExtractHandler handler = this.getHandler(className);
            if (handler == null) continue;
            try {
                obj = deser.deserialize(path);
            }
            catch (Exception ex) {
                L.log(Level.WARNING, "Can't deserialize " + path, ex);
                continue;
            }
            try {
                handler.setObjectPath(path);
                handler.extract(obj);
            }
            catch (Exception ex) {
                L.log(Level.WARNING, "Can't extract " + path, ex);
            }
        }
    }

    public void split() throws IOException {
        List<ObjectPath> pathTable = this.asset.getPaths();
        TypeTree typeTree = this.asset.getTypeTree();
        if (pathTable.size() == 1) {
            L.warning("Asset doesn't contain sub-assets!");
            return;
        }
        for (ObjectPath path : pathTable) {
            String subAssetName;
            if (this.cf != null && !this.cf.accept(path)) continue;
            String className = ClassID.getNameForID(path.getClassID(), true);
            AssetFile subAsset = new AssetFile();
            subAsset.getHeader().setFormat(this.asset.getHeader().getFormat());
            ObjectPath subFieldPath = new ObjectPath();
            subFieldPath.setClassID1(path.getClassID1());
            subFieldPath.setClassID2(path.getClassID2());
            subFieldPath.setLength(path.getLength());
            subFieldPath.setOffset(0);
            subFieldPath.setPathID(1);
            subAsset.getPaths().add(subFieldPath);
            TypeTree subTypeTree = subAsset.getTypeTree();
            subTypeTree.setEngineVersion(typeTree.getEngineVersion());
            subTypeTree.setVersion(-2);
            subTypeTree.setFormat(typeTree.getFormat());
            subTypeTree.getFields().put(path.getClassID(), typeTree.getFields().get(path.getClassID()));
            subAsset.setDataBuffer(this.asset.getPathBuffer(path));
            Path subAssetDir = this.outputDir.resolve(className);
            if (Files.notExists(subAssetDir, new LinkOption[0])) {
                Files.createDirectories(subAssetDir, new FileAttribute[0]);
            }
            subAssetName = (subAssetName = AssetExtractor.getObjectName(this.asset, path)) != null ? FilenameSanitizer.sanitizeName((String)subAssetName) : String.format("%06d", path.getPathID());
            Path subAssetFile = subAssetDir.resolve(subAssetName = subAssetName + ".asset");
            if (!Files.notExists(subAssetFile, new LinkOption[0])) continue;
            L.log(Level.INFO, "Writing {0}", subAssetFile);
            subAsset.save(subAssetFile);
        }
    }
}

