/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract;

import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.log.LogUtils;
import info.ata4.unity.cli.extract.AssetExtractHandler;
import info.ata4.unity.engine.AudioClip;
import info.ata4.unity.engine.enums.AudioType;
import info.ata4.unity.serdes.UnityObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AudioClipHandler
extends AssetExtractHandler {
    private static final Logger L = LogUtils.getLogger();
    private static final Map<AudioType, String> AUDIO_EXT;

    @Override
    public void extract(UnityObject obj) throws IOException {
        AudioClip audio = new AudioClip(obj);
        ByteBuffer audioBuffer = audio.audioBuffer;
        int stream = (Integer)obj.getValue("m_Stream");
        if (stream == 2) {
            L.log(Level.FINE, "Audio clip {0} uses external audio data", audio.name);
            int size = audio.audioBuffer.capacity();
            audio.audioBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int offset = audio.audioBuffer.getInt(0);
            ByteBuffer audioBufferAux = this.getAssetFile().getAudioBuffer();
            if (audioBufferAux == null) {
                L.log(Level.WARNING, "Audio clip {0} uses an external .resS file that doesn't exist!", audio.name);
                return;
            }
            audioBuffer = ByteBufferUtils.getSlice((ByteBuffer)audioBufferAux, (int)offset, (int)size);
        }
        if (audioBuffer.capacity() == 0) {
            L.log(Level.WARNING, "Audio clip {0} is empty", audio.name);
            return;
        }
        String ext = null;
        if (audio.type != null) {
            ext = AUDIO_EXT.get((Object)audio.type);
        }
        if (ext == null) {
            L.log(Level.WARNING, "Audio clip {0} uses unknown audio type {1}", new Object[]{audio.name, audio.type});
            ext = "bin";
        }
        this.setOutputFileName(audio.name);
        this.setOutputFileExtension(ext);
        this.writeData(audioBuffer);
    }

    static {
        EnumMap<AudioType, String> extMap = new EnumMap<AudioType, String>(AudioType.class);
        extMap.put(AudioType.ACC, "aif");
        extMap.put(AudioType.AIFF, "aif");
        extMap.put(AudioType.AUDIOQUEUE, "caf");
        extMap.put(AudioType.GCADPCM, "adp");
        extMap.put(AudioType.MOD, "mod");
        extMap.put(AudioType.MPEG, "mp3");
        extMap.put(AudioType.OGGVORBIS, "ogg");
        extMap.put(AudioType.S3M, "s3m");
        extMap.put(AudioType.WAV, "wav");
        extMap.put(AudioType.XM, "xm");
        extMap.put(AudioType.XMA, "xma");
        AUDIO_EXT = Collections.unmodifiableMap(extMap);
    }
}

