/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract;

import info.ata4.log.LogUtils;
import info.ata4.unity.cli.extract.AssetExtractHandler;
import info.ata4.unity.serdes.UnityObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MovieTextureHandler
extends AssetExtractHandler {
    private static final Logger L = LogUtils.getLogger();

    @Override
    public void extract(UnityObject obj) throws IOException {
        String ext;
        String fourCC;
        String name = (String)obj.getValue("m_Name");
        ByteBuffer movieBuffer = (ByteBuffer)obj.getValue("m_MovieData");
        switch (fourCC = new String(movieBuffer.array(), 0, 4)) {
            case "OggS": {
                ext = "ogv";
                break;
            }
            default: {
                ext = "mov";
                L.log(Level.WARNING, "Unrecognized movie fourCC \"{0}\"", fourCC);
            }
        }
        this.setOutputFileName(name);
        this.setOutputFileExtension(ext);
        this.writeData(movieBuffer);
    }
}

