/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract.mesh;

import info.ata4.io.DataInputReader;
import info.ata4.io.buffer.ByteBufferInputStream;
import info.ata4.io.streams.BitInputStream;
import info.ata4.log.LogUtils;
import info.ata4.unity.engine.ChannelInfo;
import info.ata4.unity.engine.CompressedMesh;
import info.ata4.unity.engine.Mesh;
import info.ata4.unity.engine.PackedBitVector;
import info.ata4.unity.engine.StreamInfo;
import info.ata4.unity.engine.SubMesh;
import info.ata4.unity.engine.struct.Color32;
import info.ata4.unity.engine.struct.Vector2f;
import info.ata4.unity.engine.struct.Vector3f;
import info.ata4.unity.engine.struct.Vector4f;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class MeshData {
    private static final Logger L = LogUtils.getLogger();
    private static final int CHANNEL_COUNT = 6;
    private static final int CHANNEL_VERTS = 0;
    private static final int CHANNEL_NORMALS = 1;
    private static final int CHANNEL_COLORS = 2;
    private static final int CHANNEL_UV1 = 3;
    private static final int CHANNEL_UV2 = 4;
    private static final int CHANNEL_TANGENTS = 5;
    private final Mesh mesh;
    private final List<Vector3f> vertices = new ArrayList<Vector3f>();
    private final List<Vector3f> normals = new ArrayList<Vector3f>();
    private final List<Color32> colors = new ArrayList<Color32>();
    private final List<Vector2f> uv1 = new ArrayList<Vector2f>();
    private final List<Vector2f> uv2 = new ArrayList<Vector2f>();
    private final List<Vector4f> tangents = new ArrayList<Vector4f>();
    private final List<List<Integer>> indices = new ArrayList<List<Integer>>();
    private final List<List<Integer>> triangles = new ArrayList<List<Integer>>();

    MeshData(Mesh mesh) throws IOException {
        this.mesh = mesh;
        if (mesh.meshCompression == 0) {
            this.readVertexBuffer();
            this.readIndexBuffer();
        } else {
            this.readCompressedMesh();
        }
    }

    Mesh getMesh() {
        return this.mesh;
    }

    List<Vector3f> getVertices() {
        return this.vertices;
    }

    List<Vector3f> getNormals() {
        return this.normals;
    }

    List<Color32> getColors() {
        return this.colors;
    }

    List<Vector2f> getUV1() {
        return this.uv1;
    }

    List<Vector2f> getUV2() {
        return this.uv2;
    }

    List<Vector4f> getTangents() {
        return this.tangents;
    }

    List<List<Integer>> getIndices() {
        return this.indices;
    }

    List<List<Integer>> getTriangles() {
        return this.triangles;
    }

    private int[] readPackedBits(PackedBitVector pbv) throws IOException {
        if (pbv.numItems == 0L || pbv.bitSize == 0) {
            return new int[0];
        }
        BitInputStream bis = new BitInputStream((InputStream)new ByteBufferInputStream(pbv.data));
        bis.setBitLength(pbv.bitSize.intValue());
        int numItems = pbv.numItems.intValue();
        int[] items = new int[numItems];
        for (int i = 0; i < items.length; ++i) {
            items[i] = bis.read();
        }
        return items;
    }

    private float[] readPackedFloats(PackedBitVector pbv) throws IOException {
        if (pbv.numItems == 0L || pbv.bitSize == 0) {
            return new float[0];
        }
        int[] items = this.readPackedBits(pbv);
        float[] floats = new float[items.length];
        int maxValue = (1 << pbv.bitSize) - 1;
        float range = pbv.range.floatValue() / (float)maxValue;
        float start = pbv.start.floatValue();
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = (float)items[i] * range + start;
        }
        return floats;
    }

    private float[] readPackedNormals(PackedBitVector pbv, PackedBitVector pbvSigns) throws IOException {
        int[] items = this.readPackedBits(pbv);
        int[] signs = this.readPackedBits(pbvSigns);
        if (items.length == 0 || signs.length == 0) {
            return new float[0];
        }
        for (int i = 0; i < signs.length; ++i) {
            if (signs[i] != 0) continue;
            signs[i] = -1;
        }
        float[] floats = new float[signs.length * 3];
        int maxValue = (1 << pbv.bitSize) - 1;
        float range = pbv.range.floatValue() / (float)maxValue;
        float start = pbv.start.floatValue();
        for (int i = 0; i < floats.length / 3; ++i) {
            float x = (float)items[i * 2] * range + start;
            float y = (float)items[i * 2 + 1] * range + start;
            float z = (float)((1.0 - Math.pow(x, 2.0) - Math.pow(y, 2.0)) * (double)signs[i]);
            floats[i * 3] = x;
            floats[i * 3 + 1] = y;
            floats[i * 3 + 2] = z;
        }
        return floats;
    }

    private void readVertexBuffer() throws IOException {
        ByteBuffer vertexBuffer = this.mesh.vertexData.dataSize;
        vertexBuffer.order(ByteOrder.LITTLE_ENDIAN);
        L.log(Level.FINE, "Vertex buffer size: {0}", vertexBuffer.capacity());
        DataInputReader in = DataInputReader.newReader((ByteBuffer)vertexBuffer);
        List<StreamInfo> streams = this.mesh.vertexData.streams;
        List<ChannelInfo> channels = this.mesh.vertexData.channels;
        for (StreamInfo stream : streams) {
            if (stream.channelMask.longValue() == 0L) continue;
            vertexBuffer.position(stream.offset.intValue());
            int i = 0;
            while ((long)i < this.mesh.vertexData.vertexCount) {
                block9: for (int j = 0; j < 6; ++j) {
                    if ((stream.channelMask.longValue() & (long)(1 << j)) == 0L) continue;
                    boolean half = false;
                    ChannelInfo channel = null;
                    if (!channels.isEmpty()) {
                        channel = channels.get(j);
                        half = channel.format == 1;
                    }
                    switch (j) {
                        case 0: {
                            Vector3f v = new Vector3f();
                            v.setHalf(half);
                            v.read(in);
                            this.vertices.add(v);
                            continue block9;
                        }
                        case 1: {
                            Vector3f vn = new Vector3f();
                            vn.setHalf(half);
                            vn.read(in);
                            this.normals.add(vn);
                            if (!half || channel == null || channel.dimension != 4) continue block9;
                            in.skipBytes(2);
                            continue block9;
                        }
                        case 2: {
                            Color32 c = new Color32();
                            c.read(in);
                            this.colors.add(c);
                            continue block9;
                        }
                        case 3: 
                        case 4: {
                            Vector2f vt = new Vector2f();
                            vt.setHalf(half);
                            vt.read(in);
                            if (j == 3) {
                                this.uv1.add(vt);
                                continue block9;
                            }
                            this.uv2.add(vt);
                            continue block9;
                        }
                        case 5: {
                            Vector4f t = new Vector4f();
                            t.setHalf(half);
                            t.read(in);
                            this.tangents.add(t);
                        }
                    }
                }
                in.align(stream.stride.intValue());
                ++i;
            }
        }
    }

    private void readIndexBuffer() throws IOException {
        this.mesh.indexBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DataInputReader in = DataInputReader.newReader((ByteBuffer)this.mesh.indexBuffer);
        for (SubMesh subMesh : this.mesh.subMeshes) {
            ArrayList<Integer> subMeshIndices = new ArrayList<Integer>();
            ArrayList<Integer> subMeshTriangles = new ArrayList<Integer>();
            in.position(subMesh.firstByte.longValue());
            for (long j = 0L; j < subMesh.indexCount.longValue(); ++j) {
                subMeshIndices.add(in.readUnsignedShort());
            }
            if (subMesh.topology.longValue() == 0L) {
                subMeshTriangles.addAll(subMeshIndices);
            } else {
                LinkedList tris = new LinkedList();
                for (int k = 0; k < subMeshIndices.size(); ++k) {
                    tris.addLast(subMeshIndices.get(k));
                    if (tris.size() < 3) continue;
                    int t1 = (Integer)tris.get(0);
                    int t2 = (Integer)tris.get(1);
                    int t3 = (Integer)tris.get(2);
                    tris.removeFirst();
                    if (t1 == t2 || t1 == t3 || t3 == t2) continue;
                    if (k % 2 == 0) {
                        subMeshTriangles.add(t1);
                        subMeshTriangles.add(t2);
                        subMeshTriangles.add(t3);
                        continue;
                    }
                    subMeshTriangles.add(t3);
                    subMeshTriangles.add(t2);
                    subMeshTriangles.add(t1);
                }
            }
            this.indices.add(subMeshIndices);
            this.triangles.add(subMeshTriangles);
        }
    }

    private void readCompressedMesh() throws IOException {
        CompressedMesh cmesh = this.mesh.compressedMesh;
        float[] vertexFloats = this.readPackedFloats(cmesh.vertices);
        for (int i = 0; i < vertexFloats.length / 3; ++i) {
            Vector3f v = new Vector3f();
            v.x = vertexFloats[i * 3];
            v.y = vertexFloats[i * 3 + 1];
            v.z = vertexFloats[i * 3 + 2];
            this.vertices.add(v);
        }
        float[] normalFloats = this.readPackedNormals(cmesh.normals, cmesh.normalSigns);
        for (int i = 0; i < normalFloats.length / 3; ++i) {
            Vector3f vn = new Vector3f();
            vn.x = normalFloats[i * 3];
            vn.y = normalFloats[i * 3 + 1];
            vn.z = normalFloats[i * 3 + 2];
            this.normals.add(vn);
        }
        float[] uvFloats = this.readPackedFloats(cmesh.UV);
        for (int i = 0; i < uvFloats.length / 2; ++i) {
            Vector2f vt = new Vector2f();
            vt.x = uvFloats[i * 2];
            vt.y = uvFloats[i * 2 + 1];
            if (i < vertexFloats.length / 3) {
                this.uv1.add(vt);
                continue;
            }
            this.uv2.add(vt);
        }
        int[] colorInts = this.readPackedBits(cmesh.colors);
        for (int i = 0; i < colorInts.length; ++i) {
            Color32 c = new Color32();
            c.fromInt(colorInts[i]);
            this.colors.add(c);
        }
        int[] triangleInts = this.readPackedBits(cmesh.triangles);
        for (SubMesh subMesh : this.mesh.subMeshes) {
            ArrayList<Integer> subMeshIndices = new ArrayList<Integer>();
            ArrayList<Integer> subMeshTriangles = new ArrayList<Integer>();
            int vertOfs = subMesh.firstVertex.intValue();
            int vertCount = subMesh.vertexCount.intValue();
            for (int j = vertOfs; j < vertCount; ++j) {
                subMeshTriangles.add(triangleInts[j]);
                subMeshIndices.add(triangleInts[j]);
            }
            this.indices.add(subMeshIndices);
            this.triangles.add(subMeshTriangles);
        }
    }
}

