/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.tools;

import info.ata4.log.LogUtils;
import info.ata4.unity.asset.bundle.AssetBundle;
import info.ata4.unity.cli.DisUnityOptions;
import info.ata4.util.string.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class WebDownloader {
    private static final Logger L = LogUtils.getLogger();
    private static final Pattern UNITY3D_FILE_PATTERN = Pattern.compile("\"([^\"]+.unity3d)\"");
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:26.0) Gecko/20100101 Firefox/26.0";
    private Path baseDir = Paths.get(".", new String[0]);
    private final List<Path> bundles = new ArrayList<Path>();

    public static void main(String[] args) {
        List<String> lines;
        LogUtils.configure();
        if (args.length < 1) {
            L.info("Usage: webdownloader <url list file>");
            return;
        }
        Path urlFile = Paths.get(args[0], new String[0]);
        WebDownloader downloader = new WebDownloader();
        downloader.setBaseDirectory(urlFile.getParent());
        try {
            lines = Files.readAllLines(urlFile, Charset.forName("UTF-8"));
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Can't read URL list", ex);
            return;
        }
        for (String line : lines) {
            try {
                downloader.download(line);
            }
            catch (Exception ex) {
                L.log(Level.WARNING, "Can't download from " + line, ex);
            }
        }
        List<Path> bundles = downloader.getDownloadedFiles();
        boolean learn = true;
        if (learn && !bundles.isEmpty()) {
            DisUnityOptions opts = new DisUnityOptions();
        }
    }

    public void setBaseDirectory(Path baseDir) {
        this.baseDir = baseDir;
    }

    public Path getBaseDirectory() {
        return this.baseDir;
    }

    public List<Path> getDownloadedFiles() {
        return Collections.unmodifiableList(this.bundles);
    }

    public void download(String urlString) throws MalformedURLException, IOException {
        List<String> lines;
        URL url = new URL(urlString);
        URL urlParent = new URL(FilenameUtils.getPath(urlString));
        try (InputStream is = this.getHTTPInputStream(url);){
            lines = IOUtils.readLines(is);
        }
        HashSet<String> unityFiles = new HashSet<String>();
        for (String line : lines) {
            Matcher m = UNITY3D_FILE_PATTERN.matcher(line);
            if (!m.find()) continue;
            unityFiles.add(m.group(1));
        }
        if (unityFiles.isEmpty()) {
            L.info("No downloadable asset bundles found");
        }
        for (String unityFile : unityFiles) {
            URL unityUrl;
            if (unityFile.startsWith("http")) {
                unityUrl = new URL(unityFile);
            } else {
                String unityFileFixed = unityFile.replace(" ", "%20");
                unityUrl = new URL(urlParent, unityFileFixed);
            }
            try {
                this.downloadBundle(url, unityUrl);
            }
            catch (IOException ex) {
                L.log(Level.WARNING, "Can't download bundle " + unityUrl, ex);
            }
        }
    }

    private void downloadBundle(URL indexUrl, URL unityUrl) throws IOException {
        String subDirName;
        Path subDir;
        Path tmpDir = this.baseDir.resolve("tmp");
        if (Files.notExists(tmpDir, new LinkOption[0])) {
            Files.createDirectory(tmpDir, new FileAttribute[0]);
        }
        Path tmpFile = tmpDir.resolve(UUID.randomUUID().toString() + ".unity3d");
        try (InputStream is = this.getHTTPInputStream(unityUrl);){
            Files.copy(is, tmpFile, new CopyOption[0]);
        }
        AssetBundle ab = new AssetBundle();
        ab.load(tmpFile);
        String version = ab.getEngineVersion().toString();
        String versionDirName = version.substring(0, 3);
        L.log(Level.INFO, "Revision: {0}", version);
        Path versionDir = this.baseDir.resolve(versionDirName);
        if (Files.notExists(versionDir, new LinkOption[0])) {
            Files.createDirectory(versionDir, new FileAttribute[0]);
        }
        if (Files.notExists(subDir = versionDir.resolve(subDirName = unityUrl.getHost()), new LinkOption[0])) {
            Files.createDirectory(subDir, new FileAttribute[0]);
        }
        String fileName = FilenameUtils.getName(unityUrl.getFile());
        fileName = fileName.replace("%20", " ");
        Path finalFile = subDir.resolve(fileName);
        Files.move(tmpFile, finalFile, StandardCopyOption.REPLACE_EXISTING);
        this.bundles.add(finalFile);
        String bundleName = FilenameUtils.removeExtension(fileName);
        Path sourceUrlFile = subDir.resolve(bundleName + ".txt");
        String sourceString = String.format("Bundle: %s\nIndex: %s", unityUrl.toString(), indexUrl.toString());
        FileUtils.writeStringToFile(sourceUrlFile.toFile(), sourceString);
    }

    private InputStream getHTTPInputStream(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setReadTimeout(10000);
        con.setRequestProperty("User-Agent", USER_AGENT);
        int responseCode = con.getResponseCode();
        String responseMessage = con.getResponseMessage();
        if (responseCode < 200 || responseCode > 299) {
            throw new IOException(String.format("HTTP %d %s", responseCode, responseMessage));
        }
        String contentLength = con.getHeaderField("Content-Length");
        if (contentLength != null) {
            try {
                contentLength = StringUtils.humanReadableByteCount(Integer.parseInt(contentLength), true);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        L.log(Level.INFO, "Downloading {0} ({1})", new Object[]{url, contentLength});
        return con.getInputStream();
    }
}

