/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.serdes;

import info.ata4.io.DataInputReader;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.asset.struct.TypeField;
import info.ata4.unity.cli.classfilter.ClassFilter;
import info.ata4.unity.serdes.UnityObject;
import info.ata4.unity.serdes.UnityString;
import info.ata4.unity.serdes.UnityValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Deserializer {
    private static final int ALIGN = 4;
    private final AssetFile asset;
    private DataInputReader in;
    private ByteBuffer bb;
    private boolean debug = false;

    public Deserializer(AssetFile asset) {
        this.asset = asset;
    }

    public List<UnityObject> deserialize(ClassFilter cf) throws IOException {
        ArrayList<UnityObject> objList = new ArrayList<UnityObject>();
        for (ObjectPath path : this.asset.getPaths()) {
            if (cf != null && !cf.accept(path)) continue;
            objList.add(this.deserialize(path));
        }
        return objList;
    }

    public UnityObject deserialize(ObjectPath path) throws IOException {
        this.bb = this.asset.getPathBuffer(path);
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        this.in = DataInputReader.newReader((ByteBuffer)this.bb);
        Map<Integer, TypeField> typeFields = this.asset.getTypeTree().getFields();
        TypeField type = typeFields.get(path.getClassID());
        if (type == null) {
            throw new IllegalArgumentException("Class not found in type tree");
        }
        UnityObject obj = this.readObject(type);
        if (this.bb.hasRemaining()) {
            throw new IOException("Remaining bytes: " + this.bb.remaining());
        }
        return obj;
    }

    private UnityObject readObject(TypeField type) throws IOException {
        UnityObject obj = new UnityObject();
        obj.setName(type.getName());
        obj.setType(type.getType());
        for (TypeField subType : type.getChildren()) {
            int pos = 0;
            if (this.debug) {
                pos = this.bb.position();
            }
            UnityValue<Object> value = new UnityValue<Object>();
            value.setType(subType.getType());
            value.set(this.readValue(subType));
            if (subType.isForceAlign()) {
                this.in.align(4);
            }
            obj.get().put(subType.getName(), value);
            if (!this.debug) continue;
            int bytes = this.bb.position() - pos;
            System.out.printf("0x%x: %s %s = %s, bytes: %d, flags: 0x%x 0x%x\n", pos, value.getType(), subType.getName(), value.get(), bytes, subType.getFlags1(), subType.getFlags2());
        }
        return obj;
    }

    private Object readValue(TypeField type) throws IOException {
        if (!type.getChildren().isEmpty()) {
            switch (type.getType()) {
                case "string": {
                    return this.readString(type);
                }
                case "map": 
                case "vector": 
                case "staticvector": 
                case "set": {
                    return this.readCollection(type);
                }
                case "Array": 
                case "TypelessData": {
                    return this.readArray(type);
                }
            }
            return this.readObject(type);
        }
        switch (type.getType()) {
            case "bool": {
                return this.in.readBoolean();
            }
            case "SInt8": {
                return this.in.readByte();
            }
            case "UInt8": 
            case "char": {
                return this.in.readUnsignedByte();
            }
            case "SInt16": 
            case "short": {
                return this.in.readShort();
            }
            case "UInt16": 
            case "unsigned short": {
                return this.in.readUnsignedShort();
            }
            case "SInt32": 
            case "int": {
                return this.in.readInt();
            }
            case "UInt32": 
            case "unsigned int": {
                return this.in.readUnsignedInt();
            }
            case "float": {
                return Float.valueOf(this.in.readFloat());
            }
            case "SInt64": 
            case "long": {
                return this.in.readLong();
            }
            case "UInt64": 
            case "unsigned long": {
                return this.in.readUnsignedLong();
            }
            case "double": {
                return this.in.readDouble();
            }
        }
        throw new IOException("Unknown primitive type: " + type.getType());
    }

    private UnityValue readArray(TypeField type) throws IOException {
        List<TypeField> subTypes = type.getChildren();
        if (subTypes.size() != 2) {
            throw new IOException("Unexpected number of array fields: " + subTypes.size());
        }
        TypeField typeSize = subTypes.get(0);
        TypeField typeData = subTypes.get(1);
        if (!typeSize.getName().equals("size")) {
            throw new IOException("Unexpected array size field: " + typeSize);
        }
        if (!typeData.getName().equals("data")) {
            throw new IOException("Unexpected array data field: " + typeData);
        }
        int size = (Integer)this.readValue(typeSize);
        UnityValue<Object> value = new UnityValue<Object>();
        value.setType(typeData.getType());
        switch (typeData.getType()) {
            case "SInt8": 
            case "UInt8": 
            case "char": {
                byte[] data = new byte[size];
                int bufsize = Math.min(size, (int)this.in.remaining());
                this.in.readFully(data, 0, bufsize);
                this.in.align(4);
                value.set(ByteBuffer.wrap(data));
                break;
            }
            default: {
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.readValue(typeData));
                }
                value.set(list);
            }
        }
        return value;
    }

    private UnityValue readCollection(TypeField type) throws IOException {
        return this.readArray(type.getChildren().get(0));
    }

    private UnityString readString(TypeField type) throws IOException {
        UnityValue array = this.readCollection(type);
        ByteBuffer buf = (ByteBuffer)array.get();
        return new UnityString(buf.array());
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

