/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.util;

import java.util.Objects;

public class UnityVersion
implements Comparable<UnityVersion> {
    private byte major;
    private byte minor;
    private byte patch;
    private String build;
    private String raw;

    public UnityVersion(String version) {
        try {
            this.major = this.partFromString(version.substring(0, 1));
            this.minor = this.partFromString(version.substring(2, 3));
            this.patch = this.partFromString(version.substring(4, 5));
            this.build = version.substring(5);
        }
        catch (IndexOutOfBoundsException | NumberFormatException ex) {
            this.raw = version;
        }
    }

    private byte partFromString(String part) {
        if (part.equals("x")) {
            return -1;
        }
        return Byte.valueOf(part);
    }

    private String partToString(byte part) {
        if (part == -1) {
            return "x";
        }
        return String.valueOf(part);
    }

    public boolean isValid() {
        return this.raw == null;
    }

    public byte getMajor() {
        return this.major;
    }

    public void setMajor(byte major) {
        this.major = major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public void setMinor(byte minor) {
        this.minor = minor;
    }

    public byte getPatch() {
        return this.patch;
    }

    public void setPatch(byte patch) {
        this.patch = patch;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public String toString() {
        if (this.raw != null) {
            return this.raw;
        }
        return String.format("%s.%s.%s%s", this.partToString(this.major), this.partToString(this.minor), this.partToString(this.patch), this.build);
    }

    public int hashCode() {
        if (this.raw != null) {
            return this.raw.hashCode();
        }
        int hash = 5;
        hash = 97 * hash + this.major;
        hash = 97 * hash + this.minor;
        hash = 97 * hash + this.patch;
        hash = 97 * hash + Objects.hashCode(this.build);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnityVersion other = (UnityVersion)obj;
        if (this.raw != null) {
            if (!Objects.equals(this.raw, other.raw)) {
                return false;
            }
        } else {
            if (this.major != other.major) {
                return false;
            }
            if (this.minor != other.minor) {
                return false;
            }
            if (this.patch != other.patch) {
                return false;
            }
            if (!Objects.equals(this.build, other.build)) {
                return false;
            }
            if (!Objects.equals(this.raw, other.raw)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(UnityVersion that) {
        if (!this.isValid() && !that.isValid()) {
            return this.raw.compareTo(that.raw);
        }
        if (this.major < that.major) {
            return 1;
        }
        if (this.major > that.major) {
            return -1;
        }
        if (this.minor < that.minor) {
            return 1;
        }
        if (this.minor > that.minor) {
            return -1;
        }
        if (this.patch < that.patch) {
            return 1;
        }
        if (this.patch > that.patch) {
            return -1;
        }
        return this.build.compareTo(that.build);
    }

    public boolean lesserThan(UnityVersion that) {
        return this.compareTo(that) == 1;
    }

    public boolean greaterThan(UnityVersion that) {
        return this.compareTo(that) == -1;
    }
}

