/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.util.io.image.ktx;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;

public class KTXHeader
implements Struct {
    public static final int SIZE = 64;
    public static byte[] IDENTIFIER = DatatypeConverter.parseHexBinary((String)"AB4B5458203131BB0D0A1A0A");
    public static byte[] ENDIANESS_LE = new byte[]{1, 2, 3, 4};
    public static byte[] ENDIANESS_BE = new byte[]{4, 3, 2, 1};
    public static final int GL_ETC1_RGB8_OES = 36196;
    public static final int GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 35840;
    public static final int GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 35841;
    public static final int GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 35842;
    public static final int GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 35843;
    public static final int GL_ATC_RGB_AMD = 35986;
    public static final int GL_ATC_RGBA_EXPLICIT_ALPHA_AMD = 35987;
    public static final int GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD = 34798;
    public static final int GL_COMPRESSED_RGB8_ETC2 = 37492;
    public static final int GL_COMPRESSED_SRGB8_ETC2 = 37493;
    public static final int GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37494;
    public static final int GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37495;
    public static final int GL_COMPRESSED_RGBA8_ETC2_EAC = 37496;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 37497;
    public static final int GL_COMPRESSED_R11_EAC = 37488;
    public static final int GL_COMPRESSED_SIGNED_R11_EAC = 37489;
    public static final int GL_COMPRESSED_RG11_EAC = 37490;
    public static final int GL_COMPRESSED_SIGNED_RG11_EAC = 37491;
    public static final int GL_RED = 6403;
    public static final int GL_GREEN = 6404;
    public static final int GL_BLUE = 6405;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_RG = 33319;
    public boolean swap;
    public int glType;
    public int glTypeSize;
    public int glFormat;
    public int glInternalFormat;
    public int glBaseInternalFormat;
    public int pixelWidth;
    public int pixelHeight;
    public int pixelDepth;
    public int numberOfArrayElements;
    public int numberOfFaces;
    public int numberOfMipmapLevels;
    public int bytesOfKeyValueData;

    public void read(DataInputReader in) throws IOException {
        byte[] identifier = new byte[IDENTIFIER.length];
        in.readFully(identifier);
        if (!Arrays.equals(identifier, IDENTIFIER)) {
            throw new IOException("Invalid identifier");
        }
        byte[] endianness = new byte[4];
        in.readFully(endianness);
        if (Arrays.equals(endianness, ENDIANESS_LE)) {
            this.swap = true;
        } else if (Arrays.equals(endianness, ENDIANESS_BE)) {
            this.swap = false;
        } else {
            throw new IOException("Invalid endianness");
        }
        in.setSwap(this.swap);
        this.glType = in.readInt();
        this.glTypeSize = in.readInt();
        this.glFormat = in.readInt();
        this.glInternalFormat = in.readInt();
        this.glBaseInternalFormat = in.readInt();
        this.pixelWidth = in.readInt();
        this.pixelHeight = in.readInt();
        this.pixelDepth = in.readInt();
        this.numberOfArrayElements = in.readInt();
        this.numberOfFaces = in.readInt();
        this.numberOfMipmapLevels = in.readInt();
        this.bytesOfKeyValueData = in.readInt();
    }

    public void write(DataOutputWriter out) throws IOException {
        out.setSwap(this.swap);
        out.write(IDENTIFIER);
        out.write(this.swap ? ENDIANESS_LE : ENDIANESS_BE);
        out.writeInt(this.glType);
        out.writeInt(this.glTypeSize);
        out.writeInt(this.glFormat);
        out.writeInt(this.glInternalFormat);
        out.writeInt(this.glBaseInternalFormat);
        out.writeInt(this.pixelWidth);
        out.writeInt(this.pixelHeight);
        out.writeInt(this.pixelDepth);
        out.writeInt(this.numberOfArrayElements);
        out.writeInt(this.numberOfFaces);
        out.writeInt(this.numberOfMipmapLevels);
        out.writeInt(this.bytesOfKeyValueData);
    }
}

