/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.util.io.image.tga;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import java.io.IOException;

public class TGAHeader
implements Struct {
    public static final int SIZE = 18;
    public byte idLength;
    public byte colorMapType;
    public byte imageType;
    public int cmFirstIndex;
    public int cmLength;
    public byte cmEntrySize;
    public int originX;
    public int originY;
    public int imageWidth;
    public int imageHeight;
    public byte pixelDepth;
    public byte imageDesc;

    public void read(DataInputReader in) throws IOException {
        this.idLength = in.readByte();
        this.colorMapType = in.readByte();
        this.imageType = in.readByte();
        this.cmFirstIndex = in.readUnsignedShort();
        this.cmLength = in.readUnsignedShort();
        this.cmEntrySize = in.readByte();
        this.originX = in.readUnsignedShort();
        this.originY = in.readUnsignedShort();
        this.imageWidth = in.readUnsignedShort();
        this.imageHeight = in.readUnsignedShort();
        this.pixelDepth = in.readByte();
        this.imageDesc = in.readByte();
    }

    public void write(DataOutputWriter out) throws IOException {
        out.writeByte((int)this.idLength);
        out.writeByte((int)this.colorMapType);
        out.writeByte((int)this.imageType);
        out.writeShort(this.cmFirstIndex);
        out.writeShort(this.cmLength);
        out.writeByte((int)this.cmEntrySize);
        out.writeShort(this.originX);
        out.writeShort(this.originY);
        out.writeShort(this.imageWidth);
        out.writeShort(this.imageHeight);
        out.writeByte((int)this.pixelDepth);
        out.writeByte((int)this.imageDesc);
    }
}

