/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.util.string;

public class StringUtils {
    private StringUtils() {
    }

    public static int makeID(String id) {
        if (id.length() != 4) {
            throw new IllegalArgumentException("String must be exactly 4 characters long");
        }
        byte[] bytes = id.getBytes();
        return bytes[3] << 24 | bytes[2] << 16 | bytes[1] << 8 | bytes[0];
    }

    public static String unmakeID(int id) {
        byte[] bytes = new byte[]{(byte)id, (byte)(id >>> 8), (byte)(id >>> 16), (byte)(id >>> 24)};
        return new String(bytes);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

